/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.mage;

import dev.xylonity.companions.common.entity.companion.SoulMageEntity;
import dev.xylonity.knightlib.api.scheduler.TickScheduler;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;

public abstract class AbstractSoulMageAttackGoal
extends Goal {
    protected final SoulMageEntity soulMage;
    protected int attackTicks;
    protected int nextUseTick;
    protected final int minCooldown;
    protected final int maxCooldown;
    protected boolean started;
    protected final String attackType;

    public AbstractSoulMageAttackGoal(SoulMageEntity soulMage, int minCd, int maxCd, String attackType) {
        this.soulMage = soulMage;
        this.minCooldown = minCd;
        this.maxCooldown = maxCd;
        this.attackType = attackType;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.soulMage.isAttacking()) {
            return false;
        }
        if (this.soulMage.m_5448_() == null) {
            return false;
        }
        if (this.soulMage.f_19797_ < this.nextUseTick) {
            return false;
        }
        return this.hasRequiredBook();
    }

    public boolean m_8045_() {
        return this.attackTicks < 25;
    }

    public void m_8056_() {
        this.attackTicks = 0;
        this.soulMage.setAttacking(true);
        TickScheduler.scheduleBoth((Level)this.soulMage.m_9236_(), () -> this.soulMage.setAttacking(false), (int)25);
        int rn = new Random().nextInt(3) + 1;
        this.soulMage.setAttackAnimationName(rn == 1 ? "spell" : (rn == 2 ? "spell2" : "spell3"));
        this.soulMage.setCurrentAttackType(this.attackType);
        this.started = true;
    }

    public void m_8041_() {
        this.started = false;
        this.soulMage.setCurrentAttackType("NONE");
        int randomCd = this.minCooldown + this.soulMage.m_217043_().m_188503_(this.maxCooldown - this.minCooldown + 1);
        this.nextUseTick = this.soulMage.f_19797_ + randomCd;
    }

    public void m_8037_() {
        if (!this.started) {
            return;
        }
        LivingEntity target = this.soulMage.m_5448_();
        if (target != null) {
            this.soulMage.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        }
        ++this.attackTicks;
        if (target != null) {
            this.soulMage.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        }
        if (this.shouldPerformAttack(target)) {
            this.performAttack(target);
        }
        if (this.attackTicks >= 25) {
            this.m_8041_();
        }
    }

    protected boolean shouldPerformAttack(LivingEntity target) {
        return this.attackTicks == 6 && target != null && target.m_6084_();
    }

    protected abstract void performAttack(LivingEntity var1);

    protected abstract boolean hasRequiredBook();
}

