/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.generic;

import dev.xylonity.companions.common.entity.companion.CorneliusEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class CompanionRandomHopStrollGoal
extends Goal {
    protected final CorneliusEntity mob;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    protected final double speedModifier;
    protected int interval;
    protected boolean forceTrigger;
    private boolean checkNoActionTime;

    public CompanionRandomHopStrollGoal(CorneliusEntity pMob, double pSpeedModifier) {
        this(pMob, pSpeedModifier, 120);
        this.checkNoActionTime = false;
    }

    public CompanionRandomHopStrollGoal(CorneliusEntity pMob, double pSpeedModifier, int pInterval) {
        this(pMob, pSpeedModifier, pInterval, true);
    }

    public CompanionRandomHopStrollGoal(CorneliusEntity pMob, double pSpeedModifier, int pInterval, boolean pCheckNoActionTime) {
        this.mob = pMob;
        this.speedModifier = pSpeedModifier;
        this.interval = pInterval;
        this.checkNoActionTime = pCheckNoActionTime;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        Vec3 pos;
        if (this.mob.getMainAction() != 2) {
            return false;
        }
        if (this.mob.m_20160_()) {
            return false;
        }
        if (!this.forceTrigger) {
            if (this.checkNoActionTime && this.mob.m_21216_() >= 100) {
                return false;
            }
            if (this.mob.m_217043_().m_188503_(CompanionRandomHopStrollGoal.m_186073_((int)this.interval)) != 0) {
                return false;
            }
        }
        if ((pos = this.getPosition()) == null) {
            return false;
        }
        this.wantedX = pos.f_82479_;
        this.wantedY = pos.f_82480_;
        this.wantedZ = pos.f_82481_;
        this.forceTrigger = false;
        return true;
    }

    @Nullable
    protected Vec3 getPosition() {
        return DefaultRandomPos.m_148403_((PathfinderMob)this.mob, (int)10, (int)7);
    }

    public boolean m_8045_() {
        return !this.mob.m_21573_().m_26571_() && !this.mob.m_20160_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26519_(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
    }

    public void m_8037_() {
        if (this.mob.getCycleCount() == -1) {
            this.mob.setCycleCount(this.mob.getCycleCount() + 1);
        }
        this.mob.m_21573_().m_26519_(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
        super.m_8041_();
    }

    public void trigger() {
        this.forceTrigger = true;
    }

    public void setInterval(int pNewInterval) {
        this.interval = pNewInterval;
    }
}

