/*
 * Decompiled with CFR 0.152.
 */
package dev.the_millman.christmasfestivity.core.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ChristmasConfig {
    public static ForgeConfigSpec CLIENT_CONFIG;
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec.BooleanValue CHRISTMAS_GIFT;
    public static ForgeConfigSpec.BooleanValue CHRISTMAS_MESSAGE;
    public static ForgeConfigSpec.BooleanValue TOPPER_PARTICLES;
    public static ForgeConfigSpec.BooleanValue ADVENT_CALENDAR;

    public static void init() {
        ChristmasConfig.initServer();
        ChristmasConfig.initClient();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_CONFIG, "christmas_festivity_common.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_CONFIG, "christmas_festivity_client.toml");
    }

    private static void initServer() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("General settings").push("blocks and items");
        CHRISTMAS_GIFT = builder.comment("Set to false to not receive the gift on Christmas day").define("christmas_gift", true);
        ADVENT_CALENDAR = builder.comment("Set to false to disable the right click function to receive items from the advent calendar").define("advent_calenar", true);
        builder.pop();
        COMMON_CONFIG = builder.build();
    }

    private static void initClient() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("General settings").push("general");
        CHRISTMAS_MESSAGE = builder.comment("Set to false to not receive the Christmas greetings message").define("christmas_message", true);
        TOPPER_PARTICLES = builder.comment("Set to false to not spawn the particles of Christmas Tree Toppers").define("topper_particles", true);
        builder.pop();
        CLIENT_CONFIG = builder.build();
    }
}

