/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.items;

import dan200.computercraft.core.util.Colour;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveBlock;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jspecify.annotations.Nullable;

public class DiskItem
extends Item
implements IColouredItem {
    private static final String NBT_ID = "DiskId";

    public DiskItem(Item.Properties settings) {
        super(settings);
    }

    public static ItemStack createFromIDAndColour(int id, @Nullable String label, int colour) {
        ItemStack stack = new ItemStack((ItemLike)ModRegistry.Items.DISK.get());
        DiskItem.setDiskID(stack, id);
        if (label != null) {
            stack.m_41714_((Component)Component.m_237113_((String)label));
        }
        IColouredItem.setColourBasic(stack, colour);
        return stack;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag options) {
        int id;
        if (options.m_7050_() && (id = DiskItem.getDiskID(stack)) >= 0) {
            list.add((Component)Component.m_237110_((String)"gui.computercraft.tooltip.disk_id", (Object[])new Object[]{id}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return DiskDriveBlock.defaultUseItemOn(context);
    }

    public static int getDiskID(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_(NBT_ID) ? nbt.m_128451_(NBT_ID) : -1;
    }

    public static void setDiskID(ItemStack stack, int id) {
        if (id >= 0) {
            stack.m_41784_().m_128405_(NBT_ID, id);
        }
    }

    @Override
    public int getColour(ItemStack stack) {
        int colour = IColouredItem.getColourBasic(stack);
        return colour == -1 ? Colour.WHITE.getHex() : colour;
    }
}

