/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.catalogue.client;

import com.mrcrayfish.catalogue.client.IModData;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;

public class ForgeModData
implements IModData {
    private final IModInfo info;

    public ForgeModData(IModInfo info) {
        this.info = info;
    }

    @Override
    public IModData.Type getType() {
        return IModData.Type.DEFAULT;
    }

    @Override
    public String getModId() {
        return this.info.getModId();
    }

    @Override
    public String getDisplayName() {
        return this.info.getDisplayName();
    }

    @Override
    public String getVersion() {
        return this.info.getVersion().toString();
    }

    @Override
    public String getDescription() {
        return this.info.getDescription();
    }

    @Override
    @Nullable
    public String getItemIcon() {
        String itemIcon = (String)this.info.getModProperties().get("catalogueItemIcon");
        if (itemIcon == null) {
            itemIcon = ((ModInfo)this.info).getConfigElement(new String[]{"itemIcon"}).orElse(null);
        }
        return itemIcon;
    }

    @Override
    @Nullable
    public String getImageIcon() {
        String s;
        Object v = this.info.getModProperties().get("catalogueImageIcon");
        return v instanceof String ? (s = (String)v) : null;
    }

    @Override
    public String getLicense() {
        return this.info.getOwningFile().getLicense();
    }

    @Override
    public String getCredits() {
        return this.getConfigString("credits");
    }

    @Override
    @Nullable
    public String getAuthors() {
        return this.getConfigString("authors");
    }

    @Override
    @Nullable
    public String getHomepage() {
        return this.getConfigString("displayURL");
    }

    @Override
    @Nullable
    public String getIssueTracker() {
        return this.getConfigString("issueTrackerURL");
    }

    @Override
    @Nullable
    public String getBanner() {
        return this.info.getLogoFile().orElse(null);
    }

    @Override
    @Nullable
    public String getBackground() {
        String s;
        Object v = this.info.getModProperties().get("catalogueBackground");
        return v instanceof String ? (s = (String)v) : null;
    }

    @Override
    public IModData.Update getUpdate() {
        VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)this.info);
        if (result.status().shouldDraw()) {
            return new IModData.Update(result.status().isAnimated(), result.url(), result.status().getSheetOffset());
        }
        return null;
    }

    @Override
    public boolean hasConfig() {
        return ConfigScreenHandler.getScreenFactoryFor((IModInfo)this.info).isPresent();
    }

    @Override
    public boolean isLogoSmooth() {
        return this.info.getLogoBlur();
    }

    @Override
    public void openConfigScreen(Screen parent) {
        ConfigScreenHandler.getScreenFactoryFor((IModInfo)this.info).map(f -> (Screen)f.apply(Minecraft.m_91087_(), parent)).ifPresent(newScreen -> Minecraft.m_91087_().m_91152_(newScreen));
    }

    @Nullable
    private String getConfigString(String key) {
        return ((ModInfo)this.info).getConfigElement(new String[]{key}).map(Object::toString).orElse(null);
    }
}

