/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.mixin.ai.task.memory_change_counting;

import com.abdelaziz.canary.common.ai.MemoryModificationCounter;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Behavior.class})
public class BehaviorMixin<E extends LivingEntity> {
    @Mutable
    @Shadow
    @Final
    protected Map<MemoryModuleType<?>, MemoryStatus> f_22522_;
    @Unique
    private long cachedMemoryModCount = -1L;
    @Unique
    private boolean cachedHasRequiredMemoryState;

    @Inject(method={"<init>(Ljava/util/Map;II)V"}, at={@At(value="RETURN")})
    public void init(Map<MemoryModuleType<?>, MemoryStatus> map, int int_1, int int_2, CallbackInfo ci) {
        this.f_22522_ = new Reference2ObjectOpenHashMap(map);
    }

    @Overwrite
    public boolean m_22543_(E entity) {
        Brain brain = entity.m_6274_();
        long modCount = ((MemoryModificationCounter)brain).getModCount();
        if (this.cachedMemoryModCount == modCount) {
            return this.cachedHasRequiredMemoryState;
        }
        this.cachedMemoryModCount = modCount;
        ObjectIterator fastIterator = ((Reference2ObjectOpenHashMap)this.f_22522_).reference2ObjectEntrySet().fastIterator();
        while (fastIterator.hasNext()) {
            Reference2ObjectMap.Entry entry = (Reference2ObjectMap.Entry)fastIterator.next();
            if (brain.m_21876_((MemoryModuleType)entry.getKey(), (MemoryStatus)entry.getValue())) continue;
            this.cachedHasRequiredMemoryState = false;
            return false;
        }
        this.cachedHasRequiredMemoryState = true;
        return true;
    }
}

