/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.ai.IAIParams;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class MeleeHitGoal
extends Goal {
    public static ResourceLocation ID = new ResourceLocation("brutalbosses:meleehit");
    private final Mob mob;
    private LivingEntity target = null;
    private MeleeHitParams params;
    private int attackTimer = 0;

    public MeleeHitGoal(Mob mob, IAIParams params) {
        this.params = (MeleeHitParams)params;
        this.mob = mob;
    }

    public boolean m_8036_() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null && target.m_6084_()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void m_8041_() {
        this.target = null;
        this.attackTimer = 0;
    }

    public void m_8037_() {
        if (--this.attackTimer > 0) {
            return;
        }
        double distSqr = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        if (distSqr < (double)this.params.attackDistance) {
            this.attackTimer = (int)((double)this.params.cooldown * ((double)BrutalBosses.rand.nextFloat() * 0.5 + 0.75));
            this.mob.m_6674_(InteractionHand.MAIN_HAND);
            float damage = this.params.extraDamage;
            if (this.mob.m_21204_().m_22171_(Attributes.f_22281_)) {
                damage = (float)((double)damage + this.mob.m_21133_(Attributes.f_22281_));
            }
            if (this.target.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), damage += EnchantmentHelper.m_44833_((ItemStack)this.mob.m_21205_(), (MobType)this.target.m_6336_()))) {
                int fireAspect = EnchantmentHelper.m_44914_((LivingEntity)this.mob);
                if (fireAspect > 0) {
                    this.target.m_20254_(fireAspect * 4);
                }
                if (this.params.onHitMobEffect != null) {
                    this.target.m_7292_(new MobEffectInstance(this.params.onHitMobEffect, this.params.potionduration, this.params.potionlevel));
                }
                float knockBack = this.params.knockback;
                if (this.mob.m_21204_().m_22171_(Attributes.f_22282_)) {
                    knockBack += (float)this.mob.m_21133_(Attributes.f_22282_);
                }
                if ((knockBack += (float)EnchantmentHelper.m_44894_((LivingEntity)this.mob)) > 0.0f) {
                    this.target.m_147240_((double)(knockBack * 0.5f), (double)Mth.m_14031_((float)(this.mob.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)))));
                }
                this.mob.m_19970_((LivingEntity)this.mob, (Entity)this.target);
                this.mob.m_21335_((Entity)this.target);
            }
        }
    }

    public static class MeleeHitParams
    extends IAIParams.DefaultParams {
        private float attackDistance = 2.0f;
        private float extraDamage = 2.0f;
        private MobEffect onHitMobEffect = null;
        private float knockback = 0.0f;
        private int cooldown = 30;
        private int potionlevel = 1;
        private int potionduration = 60;
        private static final String ATKDIST = "attackdist";
        private static final String EXTDMG = "damage";
        private static final String POTION = "potiononhit";
        private static final String POTION_STR = "potionlevel";
        private static final String POTION_DUR = "potionduration";
        private static final String KNOCK = "knockback";
        private static final String COOLDOWN = "cooldown";

        public MeleeHitParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(ATKDIST)) {
                this.attackDistance = jsonElement.get(ATKDIST).getAsFloat();
                this.attackDistance *= this.attackDistance;
            }
            if (jsonElement.has(EXTDMG)) {
                this.extraDamage = jsonElement.get(EXTDMG).getAsFloat();
            }
            if (jsonElement.has(POTION_STR)) {
                this.potionlevel = jsonElement.get(POTION_STR).getAsInt();
            }
            if (jsonElement.has(POTION_DUR)) {
                this.potionduration = jsonElement.get(POTION_DUR).getAsInt();
            }
            if (jsonElement.has(COOLDOWN)) {
                this.cooldown = jsonElement.get(COOLDOWN).getAsInt();
            }
            if (jsonElement.has(KNOCK)) {
                this.knockback = jsonElement.get(KNOCK).getAsFloat();
            }
            if (jsonElement.has(POTION)) {
                ResourceLocation MobEffectID = new ResourceLocation(jsonElement.get(POTION).getAsString());
                this.onHitMobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(MobEffectID);
            }
            return this;
        }
    }
}

