/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import net.unusual.blockfactorysbosses.DragonTowerStructure;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModAttributes;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModBlockEntities;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModBlocks;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModEntities;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModItems;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModParticleTypes;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModSounds;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModTabs;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="block_factorys_bosses")
public class BlockFactorysBossesMod {
    public static final Logger LOGGER = LogManager.getLogger(BlockFactorysBossesMod.class);
    public static final String MODID = "block_factorys_bosses";
    public static final DeferredRegister<StructureType<?>> STRUCTURE_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256938_, (String)"block_factorys_bosses");
    public static final RegistryObject<StructureType<DragonTowerStructure>> DRAGON_TOWER = STRUCTURE_TYPES.register("dragon_tower", () -> () -> DragonTowerStructure.CODEC);
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("block_factorys_bosses", "block_factorys_bosses"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public BlockFactorysBossesMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BlockFactorysBossesModSounds.REGISTRY.register(bus);
        BlockFactorysBossesModBlocks.REGISTRY.register(bus);
        BlockFactorysBossesModBlockEntities.REGISTRY.register(bus);
        BlockFactorysBossesModItems.REGISTRY.register(bus);
        BlockFactorysBossesModEntities.REGISTRY.register(bus);
        BlockFactorysBossesModTabs.REGISTRY.register(bus);
        BlockFactorysBossesModParticleTypes.REGISTRY.register(bus);
        BlockFactorysBossesModAttributes.REGISTRY.register(bus);
        STRUCTURE_TYPES.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

