/*
 * Decompiled with CFR 0.152.
 */
package portb.biggerstacks.mixin.vanilla.stacksize;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import portb.biggerstacks.mixin.vanilla.stacksize.ItemStackAccessor;
import portb.biggerstacks.util.ItemStackSizeHelper;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    @Inject(method={"getMaxStackSize"}, at={@At(value="RETURN")}, cancellable=true)
    private void increaseStackLimit(CallbackInfoReturnable<Integer> returnInfo) {
        ItemStackSizeHelper.applyStackSizeToItem((ItemStack)this, returnInfo);
    }

    @Redirect(method={"save"}, at=@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;putByte(Ljava/lang/String;B)V"))
    private void saveBigStack(CompoundTag tag, String key, byte p_128346_) {
        int count = ((ItemStack)this).m_41613_();
        tag.m_128344_("Count", (byte)Math.min(count, 127));
        if (count > 127) {
            tag.m_128405_("BigCount", count);
        }
    }

    @Redirect(method={"<init>(Lnet/minecraft/nbt/CompoundTag;)V"}, at=@At(value="FIELD", target="Lnet/minecraft/world/item/ItemStack;count:I", opcode=181))
    private void readBigStack(ItemStack instance, int value, CompoundTag tag) {
        ItemStackAccessor accessor = (ItemStackAccessor)instance;
        if (tag.m_128441_("BigCount")) {
            accessor.accessSetCount(tag.m_128451_("BigCount"));
        } else if (tag.m_128435_("Count") == 3) {
            accessor.accessSetCount(tag.m_128451_("Count"));
        } else {
            accessor.accessSetCount(tag.m_128445_("Count"));
        }
    }
}

