/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.hands;

import artifacts.item.wearable.WearableArtifactItem;
import artifacts.registry.ModGameRules;
import artifacts.registry.ModItems;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PickaxeHeaterItem
extends WearableArtifactItem {
    private static final Container container = new SimpleContainer(3);
    @Nullable
    private static ResourceLocation lastRecipe;

    @Override
    public boolean hasNonCosmeticEffects() {
        return ModGameRules.PICKAXE_HEATER_ENABLED.get();
    }

    @Override
    public SoundEvent getEquipSound() {
        return SoundEvents.f_11677_;
    }

    public static ObjectArrayList<ItemStack> getModifiedBlockDrops(ObjectArrayList<ItemStack> items, LootContext context, TagKey<Block> ores, TagKey<Item> rawOres) {
        LivingEntity entity;
        Object object;
        if (context.m_78936_(LootContextParams.f_81461_) && context.m_78936_(LootContextParams.f_81455_) && context.m_78936_(LootContextParams.f_81460_) && (object = context.m_165124_(LootContextParams.f_81455_)) instanceof LivingEntity && (object = (entity = (LivingEntity)object).m_9236_()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)object;
            if (ModItems.PICKAXE_HEATER.get().isEquippedBy(entity) && ModGameRules.PICKAXE_HEATER_ENABLED.get().booleanValue() && ((BlockState)context.m_165124_(LootContextParams.f_81461_)).m_204336_(ores)) {
                ObjectArrayList result = new ObjectArrayList(items.size());
                float experience = 0.0f;
                ObjectListIterator objectListIterator = items.iterator();
                while (objectListIterator.hasNext()) {
                    Optional<AbstractCookingRecipe> recipe;
                    ItemStack item;
                    ItemStack resultItem = item = (ItemStack)objectListIterator.next();
                    if (item.m_204117_(rawOres) && (recipe = PickaxeHeaterItem.getRecipeFor(item, (Level)level)).isPresent()) {
                        resultItem = recipe.get().m_5874_(container, level.m_9598_());
                        resultItem.m_41764_(resultItem.m_41613_() * item.m_41613_());
                        experience += recipe.get().m_43750_();
                    }
                    result.add((Object)resultItem);
                }
                PickaxeHeaterItem.awardExperience(level, (Vec3)context.m_165124_(LootContextParams.f_81460_), experience);
                return result;
            }
        }
        return items;
    }

    private static void awardExperience(ServerLevel level, Vec3 position, float experience) {
        int amount = Mth.m_14143_((float)experience);
        if (Math.random() < (double)Mth.m_14187_((float)experience)) {
            ++amount;
        }
        ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)position, (int)amount);
    }

    public static Optional<AbstractCookingRecipe> getRecipeFor(ItemStack item, Level level) {
        container.m_6211_();
        container.m_6836_(0, item);
        RecipeManager recipeManager = level.m_7465_();
        Optional optional = recipeManager.m_220248_(RecipeType.f_44108_, container, level, lastRecipe);
        if (optional.isPresent()) {
            Pair pair = (Pair)optional.get();
            lastRecipe = (ResourceLocation)pair.getFirst();
            return Optional.of((AbstractCookingRecipe)pair.getSecond());
        }
        return Optional.empty();
    }
}

