/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class RingEffectCloud
extends AreaEffectCloud {
    private final Map<Entity, Integer> victims = Maps.newHashMap();
    private float ringWidth = 1.0f;

    public RingEffectCloud(EntityType<? extends AreaEffectCloud> entityType, Level level) {
        super(entityType, level);
    }

    public RingEffectCloud(Level level, double x, double y, double z) {
        this(ModRegistry.RING_EFFECT_CLOUD.get(), level);
        this.m_6034_(x, y, z);
    }

    public void setRingWidth(float ringWidth) {
        this.ringWidth = ringWidth;
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("RingWidth", this.ringWidth);
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("RingWidth", 5)) {
            this.ringWidth = compound.m_128457_("RingWidth");
        }
    }

    public void m_8119_() {
        block16: {
            ArrayList list;
            float radius;
            block17: {
                boolean shouldWait;
                boolean isWaiting;
                block15: {
                    this.m_6075_();
                    isWaiting = this.m_19747_();
                    radius = this.m_19743_();
                    if (!this.m_9236_().f_46443_) break block15;
                    if (isWaiting && this.f_19796_.m_188499_()) {
                        return;
                    }
                    ParticleOptions particleOptions = this.m_19745_();
                    int particleAmount = isWaiting ? 2 : Mth.m_14167_((float)((float)Math.PI * radius * radius));
                    float centerParticleRadius = radius - this.ringWidth / 2.0f;
                    float particleRingWidth = this.ringWidth * 0.0f;
                    float outerParticleRadius = centerParticleRadius + particleRingWidth / 2.0f;
                    float innerParticleRadius = centerParticleRadius - particleRingWidth / 2.0f;
                    float actualInner = Math.max(0.0f, innerParticleRadius);
                    for (int j = 0; j < particleAmount; ++j) {
                        double p;
                        double o;
                        double n;
                        float k = Mth.m_14116_((float)(this.f_19796_.m_188501_() * (outerParticleRadius * outerParticleRadius - actualInner * actualInner) + actualInner * actualInner));
                        float angle = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                        double d = this.m_20185_() + (double)(Mth.m_14089_((float)angle) * k);
                        double e = this.m_20186_();
                        double l = this.m_20189_() + (double)(Mth.m_14031_((float)angle) * k);
                        if (particleOptions.m_6012_() == ParticleTypes.f_123811_) {
                            int m = isWaiting && this.f_19796_.m_188499_() ? 0xFFFFFF : this.m_19744_();
                            n = (float)(m >> 16 & 0xFF) / 255.0f;
                            o = (float)(m >> 8 & 0xFF) / 255.0f;
                            p = (float)(m & 0xFF) / 255.0f;
                        } else if (isWaiting) {
                            n = 0.0;
                            o = 0.0;
                            p = 0.0;
                        } else {
                            double speed = 0.15;
                            n = (0.5 - this.f_19796_.m_188500_()) * speed;
                            o = 0.01f;
                            p = (0.5 - this.f_19796_.m_188500_()) * speed;
                        }
                        this.m_9236_().m_7107_(particleOptions, d, e, l, n, o, p);
                    }
                    break block16;
                }
                if (this.f_19797_ >= this.m_146790_() + this.m_19748_()) {
                    this.m_146870_();
                    return;
                }
                boolean bl = shouldWait = this.f_19797_ < this.m_146790_();
                if (isWaiting != shouldWait) {
                    this.m_19730_(shouldWait);
                }
                if (shouldWait) {
                    return;
                }
                if (this.m_146788_() != 0.0f) {
                    this.m_19712_(radius += this.m_146788_());
                }
                if (this.f_19797_ % 5 != 0) break block16;
                this.victims.entrySet().removeIf(entry -> this.f_19797_ >= (Integer)entry.getValue());
                list = Lists.newArrayList();
                for (MobEffectInstance mobEffectInstance : this.m_146791_().m_43488_()) {
                    list.add(new MobEffectInstance(mobEffectInstance.m_19544_(), mobEffectInstance.m_267696_(i -> i / 4), mobEffectInstance.m_19564_(), mobEffectInstance.m_19571_(), mobEffectInstance.m_19572_()));
                }
                list.addAll(this.f_19685_);
                if (!list.isEmpty()) break block17;
                this.victims.clear();
                break block16;
            }
            List livingEntitiesInBB = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_());
            if (livingEntitiesInBB.isEmpty()) break block16;
            for (LivingEntity livingEntity : livingEntitiesInBB) {
                float inner;
                double r;
                double q;
                double s;
                if (this.victims.containsKey(livingEntity) || !livingEntity.m_5801_() || !((s = (q = livingEntity.m_20185_() - this.m_20185_()) * q + (r = livingEntity.m_20189_() - this.m_20189_()) * r) >= (double)((inner = Math.max(0.0f, radius - this.ringWidth)) * inner)) || !(s <= (double)(radius * radius))) continue;
                this.victims.put((Entity)livingEntity, this.f_19797_ + this.f_19689_);
                for (MobEffectInstance mobEffectInstance2 : list) {
                    if (mobEffectInstance2.m_19544_().m_8093_()) {
                        mobEffectInstance2.m_19544_().m_19461_((Entity)this, (Entity)this.m_19749_(), livingEntity, mobEffectInstance2.m_19564_(), 0.5);
                        continue;
                    }
                    livingEntity.m_147207_(new MobEffectInstance(mobEffectInstance2), (Entity)this);
                }
                if (this.m_146787_() != 0.0f) {
                    this.m_19712_(radius += this.m_146787_());
                }
                if (this.m_146789_() == 0) continue;
                this.m_19734_(this.m_19748_() + this.m_146789_());
                if (this.m_19748_() > 0) continue;
                this.m_146870_();
                return;
            }
        }
    }
}

