/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.mixin.core.plugin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import dev.uncandango.alltheleaks.feature.server.mods.minecraft.DebugThreadsHooks;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordingStream;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugThreadsStuck {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DebugThreadsStuck.class.getSimpleName());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDebugEnabled() {
        Path path = FMLPaths.CONFIGDIR.get().resolve("alltheleaks.json");
        Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().disableHtmlEscaping().serializeNulls().create();
        if (!path.toFile().exists()) {
            return false;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonObject properties = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (properties.has("debugThreadsStuck")) {
                boolean bl2 = properties.get("debugThreadsStuck").getAsBoolean();
                return bl2;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOGGER.error("Failed to load config file", (Throwable)e);
            return false;
        }
    }

    public static void start() {
    }

    public static void logThreadStarted(RecordedEvent event) {
        DebugThreadsHooks.track(event);
    }

    public static void logThreadEnded(RecordedEvent event) {
        DebugThreadsHooks.untrack(event);
    }

    static {
        if (DebugThreadsStuck.isDebugEnabled()) {
            Thread jfrThread = new Thread(() -> {
                try (RecordingStream jfrRecording = new RecordingStream();){
                    jfrRecording.enable("jdk.ThreadStart").withStackTrace();
                    jfrRecording.enable("jdk.ThreadEnd");
                    jfrRecording.onEvent("jdk.ThreadStart", DebugThreadsStuck::logThreadStarted);
                    jfrRecording.onEvent("jdk.ThreadEnd", DebugThreadsStuck::logThreadEnded);
                    jfrRecording.start();
                    try {
                        jfrRecording.awaitTermination();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            jfrThread.setDaemon(true);
            jfrThread.setName("AllTheLeaks JFR Thread");
            jfrThread.start();
        }
    }
}

