/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.item;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class GingerbreadArmorItem
extends ArmorItem {
    private static final double MIN_SPEED_BOOST = 0.1;
    private static final double MAX_SPEED_BOOST = 1.0;
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B77"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E12"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B43F"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB111")};
    private Map<Integer, Multimap<Attribute, AttributeModifier>> gingerbreadDurabilityDependentAttributes = new HashMap<Integer, Multimap<Attribute, AttributeModifier>>();
    private final Multimap<Attribute, AttributeModifier> defaultAttributes;

    public GingerbreadArmorItem(ArmorMaterial armorMaterial, ArmorItem.Type slot) {
        super(armorMaterial, slot, new Item.Properties());
        UUID uuid = ARMOR_MODIFIERS[this.f_265916_.ordinal()];
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)this.m_40404_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(uuid, "Movement speed", 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
        this.defaultAttributes = builder.build();
    }

    private Multimap<Attribute, AttributeModifier> getOrCreateDurabilityAttributes(int durabilityIn, int maxDurability) {
        if (this.gingerbreadDurabilityDependentAttributes.containsKey(durabilityIn)) {
            return this.gingerbreadDurabilityDependentAttributes.get(durabilityIn);
        }
        float scaledDurability = (float)durabilityIn / (float)maxDurability;
        double speed = 0.1 + 0.9 * (double)scaledDurability;
        UUID uuid = ARMOR_MODIFIERS[this.f_265916_.ordinal()];
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)this.m_40404_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(uuid, "Movement speed", speed, AttributeModifier.Operation.MULTIPLY_BASE));
        ImmutableMultimap attributeModifierMultimap = builder.build();
        this.gingerbreadDurabilityDependentAttributes.put(durabilityIn, (Multimap<Attribute, AttributeModifier>)attributeModifierMultimap);
        return attributeModifierMultimap;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)AlexsCaves.PROXY.getArmorProperties());
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == this.f_265916_.m_266308_() ? this.defaultAttributes : ImmutableMultimap.of();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return slot == this.f_265916_.m_266308_() ? this.getOrCreateDurabilityAttributes(stack.m_41773_(), stack.m_41776_()) : super.getAttributeModifiers(slot, stack);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        if (slot == EquipmentSlot.LEGS) {
            return "alexscaves:textures/armor/gingerbread_armor_1.png";
        }
        return "alexscaves:textures/armor/gingerbread_armor_0.png";
    }
}

