/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.GumWormEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.FlyingMount;
import com.github.alexmodguy.alexscaves.server.entity.util.KaijuMob;
import com.github.alexmodguy.alexscaves.server.entity.util.KeybindUsingMount;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.item.CandyCaneHookItem;
import com.github.alexmodguy.alexscaves.server.message.MountedEntityKeyMessage;
import com.github.alexmodguy.alexscaves.server.misc.ACLoadedMods;
import com.github.alexthe666.citadel.server.entity.collision.ICustomCollisions;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class GumWormSegmentEntity
extends Entity
implements ICustomCollisions,
KeybindUsingMount,
PlayerRideableJumping,
FlyingMount {
    private static final EntityDataAccessor<Optional<UUID>> HEAD_ENTITY_UUID = SynchedEntityData.m_135353_(GumWormSegmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> HEAD_ENTITY_ID = SynchedEntityData.m_135353_(GumWormSegmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> FRONT_ENTITY_UUID = SynchedEntityData.m_135353_(GumWormSegmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> FRONT_ENTITY_ID = SynchedEntityData.m_135353_(GumWormSegmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> BACK_ENTITY_UUID = SynchedEntityData.m_135353_(GumWormSegmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> BACK_ENTITY_ID = SynchedEntityData.m_135353_(GumWormSegmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> INDEX = SynchedEntityData.m_135353_(GumWormSegmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public boolean renderHurtFlag = false;
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;
    private float prevZRot;
    private float zRot;
    private boolean lastZRotDirection;
    private int zRotTickOffset = this.f_19796_.m_188503_(10);
    private Vec3 surfacePosition;
    private double surfaceY;
    private Vec3 prevSurfacePosition;

    public GumWormSegmentEntity(EntityType entityType, Level level) {
        super(entityType, level);
        if (ACLoadedMods.isEntityCullingLoaded()) {
            this.f_19811_ = true;
        }
    }

    public GumWormSegmentEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACEntityRegistry.GUM_WORM_SEGMENT.get(), level);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(HEAD_ENTITY_UUID, Optional.empty());
        this.f_19804_.m_135372_(HEAD_ENTITY_ID, (Object)-1);
        this.f_19804_.m_135372_(FRONT_ENTITY_UUID, Optional.empty());
        this.f_19804_.m_135372_(FRONT_ENTITY_ID, (Object)-1);
        this.f_19804_.m_135372_(BACK_ENTITY_UUID, Optional.empty());
        this.f_19804_.m_135372_(BACK_ENTITY_ID, (Object)-1);
        this.f_19804_.m_135372_(INDEX, (Object)0);
    }

    @Nullable
    public UUID getBackEntityUUID() {
        return ((Optional)this.f_19804_.m_135370_(BACK_ENTITY_UUID)).orElse(null);
    }

    public void setBackEntityUUID(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(BACK_ENTITY_UUID, Optional.ofNullable(uniqueId));
    }

    @Nullable
    public UUID getHeadUUID() {
        return ((Optional)this.f_19804_.m_135370_(HEAD_ENTITY_UUID)).orElse(null);
    }

    public void setHeadUUID(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(HEAD_ENTITY_UUID, Optional.ofNullable(uniqueId));
    }

    @Nullable
    public UUID getFrontEntityUUID() {
        return ((Optional)this.f_19804_.m_135370_(FRONT_ENTITY_UUID)).orElse(null);
    }

    public void setFrontEntityUUID(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(FRONT_ENTITY_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getHeadEntity() {
        if (!this.m_9236_().f_46443_) {
            UUID id = this.getHeadUUID();
            return id == null ? null : ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        int id = (Integer)this.f_19804_.m_135370_(HEAD_ENTITY_ID);
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    public Entity getFrontEntity() {
        if (!this.m_9236_().f_46443_) {
            UUID id = this.getFrontEntityUUID();
            return id == null ? null : ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        int id = (Integer)this.f_19804_.m_135370_(FRONT_ENTITY_ID);
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    public Entity getBackEntity() {
        if (!this.m_9236_().f_46443_) {
            UUID id = this.getBackEntityUUID();
            return id == null ? null : ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        int id = (Integer)this.f_19804_.m_135370_(BACK_ENTITY_ID);
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    public int getIndex() {
        return (Integer)this.f_19804_.m_135370_(INDEX);
    }

    public void setIndex(int i) {
        this.f_19804_.m_135381_(INDEX, (Object)i);
    }

    public void m_7378_(CompoundTag compound) {
        if (compound.m_128403_("HeadUUID")) {
            this.setHeadUUID(compound.m_128342_("HeadUUID"));
        }
        if (compound.m_128403_("FrontUUID")) {
            this.setFrontEntityUUID(compound.m_128342_("FrontUUID"));
        }
        if (compound.m_128403_("BackUUID")) {
            this.setBackEntityUUID(compound.m_128342_("BackUUID"));
        }
        this.setIndex(compound.m_128451_("Index"));
    }

    public void m_7380_(CompoundTag compound) {
        if (this.getHeadUUID() != null) {
            compound.m_128362_("HeadUUID", this.getHeadUUID());
        }
        if (this.getFrontEntityUUID() != null) {
            compound.m_128362_("FrontUUID", this.getFrontEntityUUID());
        }
        if (this.getBackEntityUUID() != null) {
            compound.m_128362_("BackUUID", this.getBackEntityUUID());
        }
        compound.m_128405_("Index", this.getIndex());
    }

    public static void createWormSegmentsFor(GumWormEntity gumWorm, int count) {
        GumWormSegmentEntity prev = null;
        GumWormSegmentEntity ridingSegment = null;
        for (int i = 0; i < count; ++i) {
            GumWormSegmentEntity current = new GumWormSegmentEntity((EntityType)ACEntityRegistry.GUM_WORM_SEGMENT.get(), gumWorm.m_9236_());
            current.setHeadUUID(gumWorm.m_20148_());
            current.setFrontEntityUUID(prev == null ? gumWorm.m_20148_() : prev.m_20148_());
            if (prev != null) {
                prev.setBackEntityUUID(current.m_20148_());
            }
            current.setIndex(i);
            current.m_146884_(current.getIdealPosition((Entity)(prev == null ? gumWorm : prev)));
            gumWorm.m_9236_().m_7967_((Entity)current);
            prev = current;
            if (i != 3) continue;
            ridingSegment = prev;
        }
        if (ridingSegment == null) {
            ridingSegment = prev;
        }
        gumWorm.setRidingSegmentUUID(ridingSegment.m_20148_());
        gumWorm.setRidingSegmentId(ridingSegment.m_19879_());
    }

    public Vec3 getIdealPosition(@Nullable Entity parent) {
        Entity front;
        Entity head = this.getHeadEntity();
        Entity entity = front = parent == null ? this.getFrontEntity() : parent;
        if (front != null) {
            float backStretch = -2.5f;
            float sideSwing = 0.0f;
            if (head != null) {
                float headDelta = Mth.m_14036_((float)((float)head.m_20184_().m_82553_()), (float)0.0f, (float)1.0f);
                if (front == head) {
                    GumWormEntity gumWorm;
                    boolean flag = head instanceof GumWormEntity && (gumWorm = (GumWormEntity)head).isLeaping();
                    backStretch -= flag ? 0.7f : 1.2f;
                }
                backStretch *= 1.0f - headDelta * 0.3f;
                sideSwing = (0.5f + (float)this.getIndex() * 0.05f) * (float)Math.sin((float)head.f_19797_ * 0.2f - (float)this.getIndex());
            }
            Vec3 offsetFromParent = new Vec3((double)sideSwing, 0.0, (double)backStretch).m_82496_(-((float)Math.toRadians(front.f_19860_))).m_82524_(-((float)Math.toRadians(front.f_19859_)));
            return front.m_20182_().m_82549_(offsetFromParent);
        }
        return this.m_20182_();
    }

    public boolean m_6087_() {
        Entity head = this.getHeadEntity();
        return head != null && head.m_6087_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity head = this.getHeadEntity();
        if (!this.m_6673_(source) && head != null) {
            head.m_6469_(source, amount);
        }
        return false;
    }

    public boolean m_6673_(DamageSource damageSource) {
        GumWormEntity gumWorm;
        Entity entity;
        if (damageSource.m_7639_() != null && (entity = this.getHeadEntity()) instanceof GumWormEntity && (gumWorm = (GumWormEntity)entity).isRidingPlayer(damageSource.m_7639_())) {
            return true;
        }
        return super.m_6673_(damageSource) || damageSource.m_276093_(DamageTypes.f_268612_) || damageSource.m_276093_(DamageTypes.f_268671_);
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevZRot = this.zRot;
        this.prevSurfacePosition = this.surfacePosition;
        this.surfacePosition = this.calculateLightAbovePosition();
        this.surfaceY = this.calculateSurfaceY();
        Entity head = this.getHeadEntity();
        Entity front = this.getFrontEntity();
        Entity back = this.getBackEntity();
        if (this.m_9236_().f_46443_) {
            if (head instanceof GumWormEntity) {
                GumWormEntity gumWorm = (GumWormEntity)head;
                this.renderHurtFlag = gumWorm.f_20916_ > 0 || gumWorm.f_20919_ > 0;
                this.lastZRotDirection = gumWorm.getZRotDirection();
            }
            if (this.lSteps > 0) {
                double d5 = this.m_20185_() + (this.lx - this.m_20185_()) / (double)this.lSteps;
                double d6 = this.m_20186_() + (this.ly - this.m_20186_()) / (double)this.lSteps;
                double d7 = this.m_20189_() + (this.lz - this.m_20189_()) / (double)this.lSteps;
                double lerpRot = Mth.m_14175_((double)(this.lyr - (double)this.m_146908_()));
                this.m_146922_(this.m_146908_() + (float)lerpRot / (float)this.lSteps);
                this.m_146926_(this.m_146909_() + (float)(this.lxr - (double)this.m_146909_()) / (float)this.lSteps);
                --this.lSteps;
                this.m_6034_(d5, d6, d7);
            } else {
                this.m_20090_();
            }
            this.spawnDustParticles(false);
            Player clientPlayer = AlexsCaves.PROXY.getClientSidePlayer();
            if (clientPlayer != null) {
                if (AlexsCaves.PROXY.isKeyDown(4)) {
                    clientPlayer.m_8127_();
                    AlexsCaves.sendMSGToServer(new MountedEntityKeyMessage(this.m_19879_(), clientPlayer.m_19879_(), 0));
                    this.postDismount((Entity)clientPlayer);
                }
                if (AlexsCaves.PROXY.isKeyDown(3)) {
                    Entity d6 = this.getHeadEntity();
                    if (d6 instanceof GumWormEntity) {
                        GumWormEntity gumWorm = (GumWormEntity)d6;
                        gumWorm.onRidingPlayerAttack();
                    }
                    AlexsCaves.sendMSGToServer(new MountedEntityKeyMessage(this.m_19879_(), clientPlayer.m_19879_(), 1));
                }
            }
        } else {
            boolean riddenFlag = false;
            this.f_19804_.m_135381_(HEAD_ENTITY_ID, (Object)(head != null ? head.m_19879_() : -1));
            this.f_19804_.m_135381_(FRONT_ENTITY_ID, (Object)(front != null ? front.m_19879_() : -1));
            this.f_19804_.m_135381_(BACK_ENTITY_ID, (Object)(back != null ? back.m_19879_() : -1));
            if (front == null || head == null) {
                if (this.f_19797_ > 3) {
                    this.m_146870_();
                }
            } else {
                GumWormEntity gumWorm;
                GumWormEntity gumWorm2;
                float maxDistFromFront = 2.0f;
                Vec3 ideal = this.getIdealPosition(front);
                Vec3 distVec = ideal.m_82546_(this.m_20182_());
                float extraLength = (float)Math.max(distVec.m_82553_() - (double)maxDistFromFront, 0.0);
                Vec3 vec31 = distVec.m_82553_() > 1.0 ? distVec.m_82541_().m_82490_((double)(1.0f + extraLength)) : distVec;
                Vec3 vec32 = this.m_20182_().m_82549_(vec31);
                boolean bl = riddenFlag = head instanceof GumWormEntity && (gumWorm2 = (GumWormEntity)head).isRidingMode();
                if (!(front.m_5830_() && !riddenFlag || head instanceof GumWormEntity && (gumWorm2 = (GumWormEntity)head).isLeaping())) {
                    float f = Mth.m_14121_((float)((float)this.m_20186_()), (float)(riddenFlag ? (float)Math.max(this.surfaceY, ideal.f_82480_) : (float)Math.min(this.surfaceY, vec31.f_82480_)), (float)1.0f);
                    vec32 = new Vec3(vec32.f_82479_, (double)f, vec32.f_82481_);
                }
                this.m_146884_(vec32);
                Vec3 frontsBack = front.m_20182_().m_82549_(new Vec3(0.0, 0.0, 3.0).m_82496_(-((float)Math.toRadians(front.m_146909_()))).m_82524_(-((float)Math.toRadians(front.m_146908_()))));
                double d0 = frontsBack.f_82479_ - this.m_20185_();
                double d1 = frontsBack.f_82480_ - this.m_20227_(0.0);
                double d2 = frontsBack.f_82481_ - this.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                float f1 = Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875))));
                float f2 = Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
                this.m_146926_(Mth.m_14148_((float)this.m_146909_(), (float)f1, (float)5.0f));
                this.m_146922_(Mth.m_14148_((float)this.m_146908_(), (float)f2, (float)7.0f));
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.9f));
                if (this.m_217005_() && head instanceof GumWormEntity && (gumWorm = (GumWormEntity)head).getHook(true) == null && gumWorm.getHook(false) == null) {
                    this.m_20153_();
                }
            }
            this.m_20242_(!riddenFlag);
        }
        this.pushEntities();
        if (this.zRotTickOffset < 0) {
            int i = (this.lastZRotDirection ? -1 : 1) * (this.getIndex() * 5 + 15);
            if (front instanceof GumWormEntity) {
                GumWormEntity prior = (GumWormEntity)front;
                this.zRot = Mth.m_14148_((float)this.zRot, (float)(prior.getBodyZRot(1.0f) + (float)i), (float)8.0f);
            } else if (front instanceof GumWormSegmentEntity) {
                GumWormSegmentEntity prior = (GumWormSegmentEntity)front;
                this.zRot = Mth.m_14148_((float)this.zRot, (float)(prior.zRot + (float)i), (float)8.0f);
            }
        } else {
            --this.zRotTickOffset;
        }
    }

    private void pushEntities() {
        if (this.m_9236_().m_5776_()) {
            this.m_9236_().m_142425_(EntityTypeTest.m_156916_(Player.class), this.m_20191_(), EntitySelector.m_20421_((Entity)this)).forEach(this::m_7334_);
        } else {
            List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_(), EntitySelector.m_20421_((Entity)this));
            if (!list.isEmpty()) {
                int i = this.m_9236_().m_46469_().m_46215_(GameRules.f_46149_);
                if (i > 0 && list.size() > i - 1 && this.f_19796_.m_188503_(4) == 0) {
                    int j = 0;
                    for (int k = 0; k < list.size(); ++k) {
                        if (((Entity)list.get(k)).m_20159_()) continue;
                        ++j;
                    }
                    if (j > i - 1) {
                        this.m_6469_(this.m_269291_().m_269354_(), 6.0f);
                    }
                }
                for (int l = 0; l < list.size(); ++l) {
                    Entity entity = (Entity)list.get(l);
                    this.m_7334_(entity);
                }
            }
        }
    }

    private void postDismount(Entity rider) {
        if (rider instanceof Player) {
            Player player = (Player)rider;
            if (player.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ACItemRegistry.CANDY_CANE_HOOK.get())) {
                CandyCaneHookItem.setReelingIn(player.m_21120_(InteractionHand.MAIN_HAND), true);
            }
            if (player.m_21120_(InteractionHand.OFF_HAND).m_150930_((Item)ACItemRegistry.CANDY_CANE_HOOK.get())) {
                CandyCaneHookItem.setReelingIn(player.m_21120_(InteractionHand.OFF_HAND), true);
            }
        }
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_7334_(Entity entity) {
        double d1;
        double d0;
        double d2;
        if (!(this.m_20365_(entity) || entity instanceof GumWormSegmentEntity || entity.f_19794_ || this.f_19794_ || !((d2 = Mth.m_14005_((double)(d0 = entity.m_20185_() - this.m_20185_()), (double)(d1 = entity.m_20189_() - this.m_20189_()))) >= (double)0.01f))) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            if (!entity.m_20160_() && (entity.m_6094_() || entity instanceof KaijuMob)) {
                entity.m_5997_(d0, 0.0, d1);
            }
        }
    }

    public boolean canPassThrough(BlockPos blockPos, BlockState blockState, VoxelShape voxelShape) {
        GumWormEntity gumWorm;
        Entity entity = this.getHeadEntity();
        boolean ridingMode = entity instanceof GumWormEntity && (gumWorm = (GumWormEntity)entity).isRidingMode();
        return GumWormEntity.canDigBlock(blockState) && (!ridingMode || !this.m_9236_().m_8055_(blockPos.m_7494_()).m_280296_() || !blockState.m_60828_((BlockGetter)this.m_9236_(), blockPos));
    }

    public boolean m_20039_(BlockPos pos, BlockState blockstate) {
        return GumWormEntity.canDigBlock(blockstate) && super.m_20039_(pos, blockstate);
    }

    public Vec3 m_20272_(Vec3 vec3) {
        return ICustomCollisions.getAllowedMovementForEntity((Entity)this, (Vec3)vec3);
    }

    public Vec3 m_7371_(float f) {
        if (this.surfacePosition != null && this.prevSurfacePosition != null) {
            Vec3 difference = this.surfacePosition.m_82546_(this.prevSurfacePosition);
            return this.prevSurfacePosition.m_82549_(difference.m_82490_((double)f)).m_82520_(0.0, (double)this.m_20192_(), 0.0);
        }
        return super.m_7371_(f);
    }

    private Vec3 calculateLightAbovePosition() {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        mutableBlockPos.m_122178_(this.m_146903_(), this.m_146904_() - 1, this.m_146907_());
        while (mutableBlockPos.m_123342_() < this.m_9236_().m_151558_() && this.m_9236_().m_8055_((BlockPos)mutableBlockPos).m_60828_((BlockGetter)this.m_9236_(), (BlockPos)mutableBlockPos)) {
            mutableBlockPos.m_122184_(0, 1, 0);
        }
        return new Vec3(this.m_20185_(), (double)mutableBlockPos.m_123342_(), this.m_20189_());
    }

    private double calculateSurfaceY() {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        mutableBlockPos.m_122169_((double)Math.round(this.surfacePosition.f_82479_), Math.max(this.surfacePosition.f_82480_, this.m_20227_(1.0)) + 2.0, (double)Math.round(this.surfacePosition.f_82481_));
        while (mutableBlockPos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)mutableBlockPos).m_60828_((BlockGetter)this.m_9236_(), (BlockPos)mutableBlockPos)) {
            mutableBlockPos.m_122184_(0, -1, 0);
        }
        return 1.0 + (double)mutableBlockPos.m_123342_();
    }

    public void spawnDustParticles(boolean surface) {
        if (this.surfaceY < this.m_20227_(1.0) && this.m_20227_(1.0) - this.surfaceY < 4.0) {
            BlockPos lightPos = BlockPos.m_274561_((double)this.m_20185_(), (double)(this.surfaceY - 1.0), (double)this.m_20189_());
            BlockState state = this.m_9236_().m_8055_(lightPos);
            if (!state.m_60795_()) {
                this.m_9236_().m_6493_((ParticleOptions)new BlockParticleOption((ParticleType)ACParticleRegistry.BIG_BLOCK_DUST.get(), state), true, this.m_20208_(0.8f), this.surfaceY + (double)this.f_19796_.m_188501_(), this.m_20262_(0.8f), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.2f), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.2f), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.2f));
            }
        }
    }

    public boolean isMoving() {
        float f = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(this.m_20186_() - this.f_19855_), (double)(this.m_20189_() - this.f_19856_));
        return f > 0.1f;
    }

    public void m_6453_(double x, double y, double z, float yr, float xr, int steps, boolean b) {
        this.lx = x;
        this.ly = y;
        this.lz = z;
        this.lyr = yr;
        this.lxr = xr;
        this.lSteps = steps;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public void m_6001_(double lerpX, double lerpY, double lerpZ) {
        this.lxd = lerpX;
        this.lyd = lerpY;
        this.lzd = lerpZ;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public boolean m_6783_(double distance) {
        return Math.sqrt(distance) < 1024.0;
    }

    public AABB m_6921_() {
        return super.m_6921_().m_82400_(8.0);
    }

    public float getBodyZRot(float partialTicks) {
        return this.prevZRot + (this.zRot - this.prevZRot) * partialTicks;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public Vec3 getRiderPosition(Entity playerOwner) {
        float f = (float)((double)(this.m_20206_() + 0.25f) + playerOwner.m_6049_());
        Vec3 offset = new Vec3(0.0, (double)f, (double)0.15f).m_82496_((float)(-Math.toRadians(this.m_146909_()))).m_82524_((float)(-Math.toRadians(this.m_146908_())));
        Vec3 position = this.m_20182_().m_82549_(offset);
        double setY = this.surfaceY;
        int worldHeight = this.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)position.f_82479_, (int)position.f_82481_);
        if (position.f_82480_ > setY || this.surfaceY > (double)((float)worldHeight - 3.0f)) {
            setY = position.f_82480_;
        }
        return new Vec3(position.f_82479_, setY, position.f_82481_);
    }

    protected void clampRotation(LivingEntity livingEntity) {
        livingEntity.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(livingEntity.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        livingEntity.f_19859_ += f1 - f;
        livingEntity.f_20884_ += f1 - f;
        livingEntity.m_146922_(livingEntity.m_146908_() + f1 - f);
        livingEntity.m_5616_(livingEntity.m_146908_());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        if (this.m_20365_(passenger) && passenger instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)passenger;
            if (!this.m_146899_()) {
                Entity entity;
                this.clampRotation(living);
                if (passenger instanceof Player && (entity = this.getHeadEntity()) instanceof GumWormEntity) {
                    GumWormEntity gumWorm = (GumWormEntity)entity;
                    gumWorm.tickController((Player)passenger);
                }
                Vec3 riderPosition = this.getRiderPosition(passenger);
                moveFunction.m_20372_(passenger, riderPosition.f_82479_, riderPosition.f_82480_, riderPosition.f_82481_);
                return;
            }
        }
        super.m_19956_(passenger, moveFunction);
    }

    @Override
    public void onKeyPacket(Entity keyPresser, int type) {
        Entity entity;
        if (type == 0) {
            keyPresser.m_8127_();
            this.postDismount(keyPresser);
        }
        if (type == 1 && (entity = this.getHeadEntity()) instanceof GumWormEntity) {
            GumWormEntity gumWorm = (GumWormEntity)entity;
            gumWorm.onRidingPlayerAttack();
        }
    }

    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            return (Player)entity;
        }
        return null;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_142391_() {
        return (this.m_146911_() == null || this.m_146911_().m_146966_()) && !this.m_20159_();
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ACItemRegistry.getSpawnEggFor((EntityType)ACEntityRegistry.GUM_WORM.get()));
    }

    public boolean m_6109_() {
        return this.m_21515_();
    }

    public void m_7888_(int i) {
    }

    public boolean m_7132_() {
        GumWormEntity gumWorm;
        Entity entity = this.getHeadEntity();
        return entity instanceof GumWormEntity && !(gumWorm = (GumWormEntity)entity).isLeaping() && !gumWorm.recentlyLeapt();
    }

    public void m_7199_(int i) {
        Entity entity = this.getHeadEntity();
        if (entity instanceof GumWormEntity) {
            GumWormEntity gumWorm = (GumWormEntity)entity;
            gumWorm.onPlayerJump(i);
        }
    }

    public void m_8012_() {
    }
}

