/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file.worldsave.biome;

import net.minecraft.nbt.ListTag;
import net.minecraft.util.BitStorage;
import net.minecraft.util.Mth;
import net.minecraft.util.SimpleBitStorage;

public class WorldDataReaderSectionBiomeData {
    private final ListTag paletteTag;
    private final long[] biomesLongArray;
    private BitStorage biomesBitArray;
    private boolean triedReadingData;

    public WorldDataReaderSectionBiomeData(ListTag paletteTag, long[] biomesLongArray) {
        this.paletteTag = paletteTag;
        this.biomesLongArray = biomesLongArray;
    }

    public boolean hasDifferentBiomes() {
        return this.biomesLongArray != null;
    }

    public String get(int quadX, int sectionQuadY, int quadZ) {
        if (!this.hasDifferentBiomes()) {
            return this.paletteTag.isEmpty() ? null : this.paletteTag.get(0).m_7916_();
        }
        if (!this.triedReadingData && this.biomesBitArray == null && this.biomesLongArray != null) {
            this.triedReadingData = true;
            int bits = Mth.m_14163_((int)this.paletteTag.size());
            try {
                this.biomesBitArray = new SimpleBitStorage(bits, 64, this.biomesLongArray);
            }
            catch (SimpleBitStorage.InitializationException initializationException) {
                // empty catch block
            }
        }
        if (this.biomesBitArray == null) {
            return this.paletteTag.isEmpty() ? null : this.paletteTag.get(0).m_7916_();
        }
        int pos3D = sectionQuadY << 4 | quadZ << 2 | quadX;
        int biomePaletteIndex = this.biomesBitArray.m_13514_(pos3D);
        if (biomePaletteIndex >= this.paletteTag.size()) {
            return null;
        }
        return this.paletteTag.m_128778_(biomePaletteIndex);
    }
}

