/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen.structure.vampirealtar;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.blocks.DarkStoneBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModLootTables;
import de.teamlapen.vampirism.core.ModStructures;
import de.teamlapen.vampirism.entity.vampire.AdvancedVampireEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;

public class VampireAltarPieces {
    private static final ResourceLocation LOCATION_SMALL = new ResourceLocation("vampirism", "altar_small");
    private static final ResourceLocation LOCATION_BIG = new ResourceLocation("vampirism", "altar_big");
    private static final ResourceLocation LOCATION_SMALL_OLD = new ResourceLocation("vampirism", "altar_small_old");
    private static final ResourceLocation LOCATION_BIG_OLD = new ResourceLocation("vampirism", "altar_big_old");

    public static void addPieces(StructureTemplateManager structureTemplateManager, StructurePieceAccessor pieceAccessor, RandomSource random, BlockPos pos) {
        ResourceLocation location = (double)random.m_188501_() < 0.2 ? ((double)random.m_188501_() < 0.3 ? LOCATION_BIG_OLD : LOCATION_BIG) : ((double)random.m_188501_() < 0.5 ? LOCATION_SMALL_OLD : LOCATION_SMALL);
        pieceAccessor.m_142679_((StructurePiece)new VampireAltarPiece(structureTemplateManager, location, pos));
    }

    public static class VampireAltarPiece
    extends TemplateStructurePiece {
        public VampireAltarPiece(StructureTemplateManager pStructureTemplateManager, ResourceLocation pLocation, BlockPos pPos) {
            super((StructurePieceType)ModStructures.VAMPIRE_ALTAR_PIECE.get(), 0, pStructureTemplateManager, pLocation, pLocation.toString(), VampireAltarPiece.makeSettings(), pPos);
        }

        public VampireAltarPiece(StructureTemplateManager pStructureTemplateManager, CompoundTag pTag) {
            super((StructurePieceType)ModStructures.VAMPIRE_ALTAR_PIECE.get(), pTag, pStructureTemplateManager, id -> VampireAltarPiece.makeSettings());
        }

        protected void m_213704_(@NotNull String pName, @NotNull BlockPos pPos, @NotNull ServerLevelAccessor pLevel, @NotNull RandomSource pRandom, @NotNull BoundingBox pBox) {
            switch (pName) {
                case "chest": {
                    pLevel.m_7731_(pPos, ((DarkStoneBlock)((Object)ModBlocks.DARK_STONE_BRICKS.get())).m_49966_(), 3);
                    BlockEntity blockEntity = pLevel.m_7702_(pPos.m_7495_());
                    if (!(blockEntity instanceof ChestBlockEntity)) break;
                    ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
                    chest.m_59626_(ModLootTables.CHEST_VAMPIRE_ALTAR, pRandom.m_188505_());
                    break;
                }
                case "entity": {
                    pLevel.m_7471_(pPos, false);
                    if (VampirismAPI.sundamageRegistry().hasSunDamage((LevelAccessor)pLevel, pPos)) break;
                    AdvancedVampireEntity advancedVampireEntity = (AdvancedVampireEntity)((EntityType)ModEntities.ADVANCED_VAMPIRE.get()).m_20615_((Level)pLevel.m_6018_());
                    advancedVampireEntity.m_6034_((double)pPos.m_123341_() + 0.5, pPos.m_123342_(), (double)pPos.m_123343_() + 0.5);
                    pLevel.m_7967_((Entity)advancedVampireEntity);
                }
            }
        }

        @NotNull
        private static StructurePlaceSettings makeSettings() {
            return new StructurePlaceSettings().m_74379_(Rotation.NONE).m_74377_(Mirror.NONE).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74048_);
        }
    }
}

