/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public record ClientboundBossEventSoundPacket(UUID bossEventUuid, ResourceKey<SoundEvent> sound) implements IMessage.IClientBoundMessage
{
    public static final Codec<ClientboundBossEventSoundPacket> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.xmap(UUID::fromString, UUID::toString).fieldOf("boss_event_uuid").forGetter(l -> l.bossEventUuid), (App)ResourceKey.m_195966_((ResourceKey)ForgeRegistries.Keys.SOUND_EVENTS).fieldOf("sound").forGetter(l -> l.sound)).apply((Applicative)builder, ClientboundBossEventSoundPacket::new));

    static void encode(@NotNull ClientboundBossEventSoundPacket msg, @NotNull FriendlyByteBuf buf) {
        buf.m_272073_(CODEC, (Object)msg);
    }

    @NotNull
    static ClientboundBossEventSoundPacket decode(@NotNull FriendlyByteBuf buf) {
        return (ClientboundBossEventSoundPacket)buf.m_271872_(CODEC);
    }

    public static void handle(ClientboundBossEventSoundPacket msg, @NotNull Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampirismMod.proxy.addBossEventSound(msg.bossEventUuid, msg.sound));
        ctx.setPacketHandled(true);
    }
}

