/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.VampirismVampireSwordItem;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeartSeekerItem
extends VampirismVampireSwordItem
implements IItemWithTier {
    public static final VampirismVampireSwordItem.VampireSwordMaterial NORMAL = new VampirismVampireSwordItem.VampireSwordMaterial(IItemWithTier.TIER.NORMAL, 2, 500, -3.6f, 1.5f, 14, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BLOOD_INFUSED_IRON_INGOT.get()}), 1.3f);
    public static final VampirismVampireSwordItem.VampireSwordMaterial ENHANCED = new VampirismVampireSwordItem.VampireSwordMaterial(IItemWithTier.TIER.ENHANCED, 2, 1750, -3.5f, 2.5f, 14, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BLOOD_INFUSED_ENHANCED_IRON_INGOT.get()}), 1.4f);
    public static final VampirismVampireSwordItem.VampireSwordMaterial ULTIMATE = new VampirismVampireSwordItem.VampireSwordMaterial(IItemWithTier.TIER.ULTIMATE, 2, 2500, -3.4f, 3.5f, 14, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BLOOD_INFUSED_ENHANCED_IRON_INGOT.get()}), 1.5f);
    @NotNull
    private final IItemWithTier.TIER tier;

    public HeartSeekerItem(@NotNull VampirismVampireSwordItem.VampireSwordMaterial material) {
        super(material, 3, new Item.Properties());
        this.tier = material.getTier();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        this.addTierInformation(tooltip);
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }

    public float getXpRepairRatio(ItemStack stack) {
        return this.getVampirismTier() == IItemWithTier.TIER.ULTIMATE ? super.getXpRepairRatio(stack) / 2.0f : super.getXpRepairRatio(stack);
    }

    @Override
    protected float getChargeUsage() {
        return (float)((Double)VampirismConfig.BALANCE.vampireSwordBloodUsageFactor.get() / 100.0 * (double)(this.getVampirismTier().ordinal() + 2) / 2.0);
    }

    @Override
    protected float getChargingFactor(ItemStack stack) {
        return (float)((Double)VampirismConfig.BALANCE.vampireSwordChargingFactor.get() * 2.0 / (double)((float)this.getVampirismTier().ordinal() + 2.0f));
    }
}

