/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.player.vampire.VampireLeveling;
import de.teamlapen.vampirism.inventory.AltarInfusionMenu;
import de.teamlapen.vampirism.items.PureBloodItem;
import de.teamlapen.vampirism.items.VampireBookItem;
import de.teamlapen.vampirism.items.VampirismItemBloodFoodItem;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.CyclingSlotBackground;
import net.minecraft.client.gui.screens.inventory.ItemCombinerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AltarInfusionScreen
extends ItemCombinerScreen<AltarInfusionMenu> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("vampirism", "textures/gui/altar4.png");
    private static final ResourceLocation EMPTY_PURE_BLOOD = new ResourceLocation("vampirism", "item/empty_pure_blood");
    private static final ResourceLocation EMPTY_HUMAN_HEART = new ResourceLocation("vampirism", "item/empty_human_heart");
    private static final ResourceLocation EMPTY_VAMPIRE_BOOK = new ResourceLocation("vampirism", "item/empty_vampire_book");
    private final CyclingSlotBackground pureBloodIcon = new CyclingSlotBackground(0);
    private final CyclingSlotBackground humanHeartIcon = new CyclingSlotBackground(1);
    private final CyclingSlotBackground vampireBookIcon = new CyclingSlotBackground(2);

    public AltarInfusionScreen(@NotNull AltarInfusionMenu inventorySlotsIn, @NotNull Inventory playerInventory, @NotNull Component name) {
        super((ItemCombinerMenu)inventorySlotsIn, playerInventory, name, BACKGROUND);
    }

    protected void m_181908_() {
        super.m_181908_();
        Optional<VampireLeveling.AltarInfusionRequirements> requirement = ((AltarInfusionMenu)this.f_97732_).getRequirement();
        this.pureBloodIcon.m_266287_(requirement.filter(s -> s.pureBloodQuantity() > 0).map(s -> List.of(EMPTY_PURE_BLOOD)).orElse(List.of()));
        this.humanHeartIcon.m_266287_(requirement.filter(s -> s.humanHeartQuantity() > 0).map(s -> List.of(EMPTY_HUMAN_HEART)).orElse(List.of()));
        this.vampireBookIcon.m_266287_(requirement.filter(s -> s.vampireBookQuantity() > 0).map(s -> List.of(EMPTY_VAMPIRE_BOOK)).orElse(List.of()));
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
        this.renderOnBoardingTooltips(graphics, pMouseX, pMouseY);
    }

    private void renderOnBoardingTooltips(GuiGraphics graphics, int pMouseX, int pMouseY) {
        if (this.f_97734_ != null && this.f_97734_.f_40219_ < 3) {
            ItemStack stack;
            Optional<Object> optional = Optional.empty();
            Optional<VampireLeveling.AltarInfusionRequirements> req = ((AltarInfusionMenu)this.f_97732_).getRequirement();
            Integer missing = req.map(arg_0 -> this.lambda$renderOnBoardingTooltips$6(stack = this.f_97734_.m_7993_(), arg_0)).orElse(0);
            if (missing > 0) {
                Object[] objectArray = new Object[2];
                objectArray[0] = missing;
                objectArray[1] = switch (this.f_97734_.f_40219_) {
                    case 0 -> req.map(VampireLeveling.AltarInfusionRequirements::pureBloodLevel).map(PureBloodItem::getBloodItemForLevel).map(PureBloodItem::getCustomName).orElseGet(Component::m_237119_);
                    case 1 -> ((VampirismItemBloodFoodItem)((Object)ModItems.HUMAN_HEART.get())).m_7968_().m_41786_();
                    case 2 -> ((VampireBookItem)ModItems.VAMPIRE_BOOK.get()).m_7968_().m_41786_();
                    default -> null;
                };
                optional = Optional.of(Component.m_237110_((String)"text.vampirism.altar_infusion.ritual_missing_items", (Object[])objectArray));
            }
            optional.ifPresent(component -> graphics.m_280557_(this.f_96547_, component, pMouseX, pMouseY));
        }
    }

    protected void m_7286_(@NotNull GuiGraphics graphics, float pPartialTick, int pX, int pY) {
        super.m_7286_(graphics, pPartialTick, pX, pY);
        this.pureBloodIcon.m_266270_(this.f_97732_, graphics, pPartialTick, this.f_97735_, this.f_97736_);
        this.humanHeartIcon.m_266270_(this.f_97732_, graphics, pPartialTick, this.f_97735_, this.f_97736_);
        this.vampireBookIcon.m_266270_(this.f_97732_, graphics, pPartialTick, this.f_97735_, this.f_97736_);
    }

    protected void m_266390_(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        Optional<Object> component = Optional.empty();
        Optional<VampireLeveling.AltarInfusionRequirements> requirement = ((AltarInfusionMenu)this.f_97732_).getRequirement();
        if (requirement.isEmpty()) {
            component = Optional.of(Component.m_237115_((String)"text.vampirism.altar_infusion.ritual_level_wrong"));
        }
        component.ifPresent(c -> graphics.m_280245_(this.f_96547_, this.f_96547_.m_92923_((FormattedText)c, 115), this.f_97735_ + 10, this.f_97736_ + 60));
    }

    private /* synthetic */ Integer lambda$renderOnBoardingTooltips$6(ItemStack stack, VampireLeveling.AltarInfusionRequirements s) {
        return switch (this.f_97734_.f_40219_) {
            case 0 -> s.pureBloodQuantity() - stack.m_41613_();
            case 1 -> s.humanHeartQuantity() - stack.m_41613_();
            case 2 -> s.vampireBookQuantity() - stack.m_41613_();
            default -> 0;
        };
    }
}

