/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.client.gui.screens.radialmenu;

import de.teamlapen.lib.lib.client.gui.screens.radialmenu.DrawCallback;
import de.teamlapen.lib.lib.client.gui.screens.radialmenu.IRadialMenuSlot;
import de.teamlapen.lib.lib.client.gui.screens.radialmenu.SecondaryIconPosition;
import java.util.List;
import java.util.function.IntConsumer;
import net.minecraft.client.gui.GuiGraphics;

public class RadialMenu<T> {
    private final IntConsumer setSelectedSlot;
    private final List<IRadialMenuSlot<T>> radialMenuSlots;
    private final boolean showMoreSecondaryItems;
    private final SecondaryIconPosition secondaryIconStartingPosition;
    private final DrawCallback<T> drawCallback;
    private final int offset;

    public RadialMenu(IntConsumer setSelectedSlot, List<IRadialMenuSlot<T>> radialMenuSlots, DrawCallback<T> drawCallback, int offset) {
        this.setSelectedSlot = setSelectedSlot;
        this.radialMenuSlots = radialMenuSlots;
        this.showMoreSecondaryItems = false;
        this.secondaryIconStartingPosition = SecondaryIconPosition.NORTH;
        this.drawCallback = drawCallback;
        this.offset = offset;
    }

    public RadialMenu(IntConsumer setSelectedSlot, List<IRadialMenuSlot<T>> radialMenuSlots, SecondaryIconPosition secondaryIconStartingPosition, DrawCallback<T> drawCallback, int offset) {
        this.setSelectedSlot = setSelectedSlot;
        this.radialMenuSlots = radialMenuSlots;
        this.showMoreSecondaryItems = true;
        this.secondaryIconStartingPosition = secondaryIconStartingPosition;
        this.drawCallback = drawCallback;
        this.offset = offset;
    }

    public List<IRadialMenuSlot<T>> getRadialMenuSlots() {
        return this.radialMenuSlots;
    }

    public void setCurrentSlot(int slot) {
        this.setSelectedSlot.accept(slot);
    }

    public boolean isShowMoreSecondaryItems() {
        return this.showMoreSecondaryItems;
    }

    public SecondaryIconPosition getSecondaryIconStartingPosition() {
        return this.secondaryIconStartingPosition;
    }

    public void drawIcon(T objectToBeDrawn, GuiGraphics graphics, int positionX, int positionY, int size) {
        this.drawCallback.accept(objectToBeDrawn, graphics, positionX, positionY, size, false);
    }

    public int getOffset() {
        return this.offset;
    }
}

