/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.trades.trades;

import com.google.gson.JsonObject;
import com.lion.graveyard.trades.trades.JsonTradeOffer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.NotNull;

public class JsonSellStructureMapTradeOffer
extends JsonTradeOffer {
    @Override
    @NotNull
    public VillagerTrades.ItemListing deserialize(JsonObject json) {
        this.loadDefaultStats(json);
        TagKey structure = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)JsonSellStructureMapTradeOffer.readIdentifier(json, "structure_id", ""));
        String name = JsonSellStructureMapTradeOffer.readString(json, "name", "");
        ItemStack currency = JsonSellStructureMapTradeOffer.getItemStackFromJson(json.get("priceIn").getAsJsonObject());
        ItemStack buy = JsonSellStructureMapTradeOffer.getItemStackFromJson(json.get("buy").getAsJsonObject());
        return new Factory(buy, currency, (TagKey<Structure>)structure, name, this.maxUses, this.experience, this.priceMultiplier);
    }

    private static class Factory
    implements VillagerTrades.ItemListing {
        private final ItemStack currency;
        private final ItemStack buy;
        private final String nameKey;
        private final TagKey<Structure> structure;
        private final int maxUses;
        private final int experience;
        private final float multiplier;

        public Factory(ItemStack buy, ItemStack currency, TagKey<Structure> structure, String nameKey, int maxUses, int experience, float multiplier) {
            this.buy = buy;
            this.currency = currency;
            this.structure = structure;
            this.nameKey = nameKey;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = multiplier;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            Level level = entity.m_9236_();
            if (!(level instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverWorld = (ServerLevel)level;
            BlockPos blockPos = serverWorld.m_215011_(this.structure, entity.m_20183_(), 100, true);
            if (blockPos != null) {
                ItemStack itemStack = MapItem.m_42886_((Level)serverWorld, (int)blockPos.m_123341_(), (int)blockPos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
                MapItem.m_42850_((ServerLevel)serverWorld, (ItemStack)itemStack);
                MapItemSavedData.m_77925_((ItemStack)itemStack, (BlockPos)blockPos, (String)"+", (MapDecoration.Type)MapDecoration.Type.RED_X);
                itemStack.m_41714_((Component)Component.m_237115_((String)this.nameKey));
                return new MerchantOffer(this.currency, this.buy, itemStack, this.maxUses, this.experience, this.multiplier);
            }
            return null;
        }
    }
}

