/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public abstract class CarvingRecipe
implements Recipe<Container> {
    protected final Ingredient input;
    protected final ItemStack output;
    private final RecipeType<?> type;
    private final RecipeSerializer<?> serializer;
    protected final ResourceLocation id;
    protected final String group;

    public CarvingRecipe(RecipeType<?> type, RecipeSerializer<?> serializer, ResourceLocation id, String group, Ingredient input, ItemStack output) {
        this.type = type;
        this.serializer = serializer;
        this.id = id;
        this.group = group;
        this.input = input;
        this.output = output;
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    public RecipeSerializer<?> m_7707_() {
        return this.serializer;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList defaultedList = NonNullList.m_122779_();
        defaultedList.add((Object)this.input);
        return defaultedList;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_5874_(Container inventory, RegistryAccess registryManager) {
        return this.output.m_41777_();
    }

    public ItemStack m_8043_(RegistryAccess registryManager) {
        return this.output;
    }

    public static class Serializer<T extends CarvingRecipe>
    implements RecipeSerializer<T> {
        final RecipeFactory<T> recipeFactory;

        public Serializer(RecipeFactory<T> recipeFactory) {
            this.recipeFactory = recipeFactory;
        }

        public T read(ResourceLocation identifier, JsonObject jsonObject) {
            String string = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            Ingredient ingredient = GsonHelper.m_13885_((JsonObject)jsonObject, (String)"ingredient") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)jsonObject, (String)"ingredient")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"ingredient"));
            String string2 = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"result");
            int i = GsonHelper.m_13927_((JsonObject)jsonObject, (String)"count");
            ItemStack itemStack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(string2)), i);
            return this.recipeFactory.create(identifier, string, ingredient, itemStack);
        }

        public T read(ResourceLocation identifier, FriendlyByteBuf packetByteBuf) {
            String string = packetByteBuf.m_130277_();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)packetByteBuf);
            ItemStack itemStack = packetByteBuf.m_130267_();
            return this.recipeFactory.create(identifier, string, ingredient, itemStack);
        }

        public void write(FriendlyByteBuf packetByteBuf, T cuttingRecipe) {
            packetByteBuf.m_130070_(((CarvingRecipe)cuttingRecipe).group);
            ((CarvingRecipe)cuttingRecipe).input.m_43923_(packetByteBuf);
            packetByteBuf.m_130055_(((CarvingRecipe)cuttingRecipe).output);
        }

        public static interface RecipeFactory<T extends CarvingRecipe> {
            public T create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4);
        }
    }
}

