/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.entities;

import com.lion.graveyard.entities.GraveyardMinionEntity;
import com.lion.graveyard.entities.ai.goals.AttackWithOwnerGoal;
import com.lion.graveyard.entities.ai.goals.FollowOwnerGoal;
import com.lion.graveyard.entities.ai.goals.GhoulingMeleeAttackGoal;
import com.lion.graveyard.entities.ai.goals.SitGoal;
import com.lion.graveyard.entities.ai.goals.TrackOwnerAttackerGoal;
import com.lion.graveyard.init.TGAdvancements;
import com.lion.graveyard.init.TGBlocks;
import com.lion.graveyard.init.TGParticles;
import com.lion.graveyard.init.TGSounds;
import com.lion.graveyard.item.BoneStaffItem;
import com.lion.graveyard.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GhoulingEntity
extends GraveyardMinionEntity
implements GeoEntity,
MenuProvider {
    private AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> ATTACK_ANIM_TIMER;
    private static final EntityDataAccessor<Integer> ANIMATION;
    private static final EntityDataAccessor<Integer> SPAWN_TIMER;
    private static final EntityDataAccessor<Integer> TELEPORT_TIMER;
    private static final EntityDataAccessor<ItemStack> STAFF;
    private static final EntityDataAccessor<Boolean> COFFIN;
    private static final EntityDataAccessor<Byte> VARIANT;
    private final RawAnimation SPAWN_ANIMATION = RawAnimation.begin().then("spawn", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation IDLE_ANIMATION = RawAnimation.begin().then("idle", Animation.LoopType.LOOP);
    private final RawAnimation ATTACK_ANIMATION = RawAnimation.begin().then("attack", Animation.LoopType.LOOP);
    private final RawAnimation WALK_ANIMATION = RawAnimation.begin().then("walk", Animation.LoopType.LOOP);
    private final RawAnimation DEATH_ANIMATION = RawAnimation.begin().then("death", Animation.LoopType.PLAY_ONCE);
    protected static final int ANIMATION_SPAWN = 0;
    protected static final int ANIMATION_IDLE = 1;
    protected static final int ANIMATION_MELEE = 2;
    protected static final int ANIMATION_WALK = 3;
    protected static final int ANIMATION_DEATH = 4;
    public final int ATTACK_ANIMATION_DURATION = 14;
    protected Container inventory;
    private static final List<Item> GHOULING_HOLDABLE;
    public boolean playAttackSound = false;

    public GhoulingEntity(EntityType<? extends GhoulingEntity> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new GhoulingEscapeDangerGoal(1.5));
        this.f_21345_.m_25352_(2, (Goal)new SitGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new GhoulingMeleeAttackGoal(this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new TrackOwnerAttackerGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new AttackWithOwnerGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public static AttributeSupplier.Builder createGhoulingAttributes() {
        return PathfinderMob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22285_, 2.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22281_, 6.5).m_22268_(Attributes.f_22279_, 0.31).m_22268_(Attributes.f_22277_, 35.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION, (Object)1);
        this.f_19804_.m_135372_(STAFF, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(ATTACK_ANIM_TIMER, (Object)0);
        this.f_19804_.m_135372_(COFFIN, (Object)false);
        this.f_19804_.m_135372_(SPAWN_TIMER, (Object)0);
        this.f_19804_.m_135372_(TELEPORT_TIMER, (Object)0);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    protected void m_8024_() {
        if (this.getAttackAnimTimer() == 14) {
            this.setAnimationState(2);
        }
        if (this.getAttackAnimTimer() > 0) {
            int animTimer = this.getAttackAnimTimer() - 1;
            this.setAttackAnimTimer(animTimer);
        }
        if (this.getSpawnTimer() > 0) {
            this.setSpawnTimer(this.getSpawnTimer() - 1);
        }
        if (this.getTeleportTimer() > 0) {
            this.setTeleportTimer(this.getTeleportTimer() - 1);
        }
        if (this.m_21223_() < this.m_21233_()) {
            this.m_5634_(0.01f);
        }
        super.m_8024_();
    }

    public void m_8107_() {
        if (this.getSpawnTimer() == 50) {
            this.m_20193_().m_5594_(null, this.m_20183_(), TGSounds.GHOULING_SPAWN.get(), SoundSource.HOSTILE, 4.0f, 1.5f);
            this.m_20193_().m_5594_(null, this.m_20183_(), TGSounds.GHOUL_ROAR.get(), SoundSource.HOSTILE, 1.0f, -2.0f);
        }
        if (this.isInSittingPose() && this.f_19796_.m_188503_(5) == 0) {
            MathUtil.createParticleCircle(this.m_20193_(), this.m_20185_(), this.m_20186_() + 0.6, this.m_20189_(), 0.0, 0.0, 0.0, 1.5f, TGParticles.GRAVEYARD_SOUL_PARTICLE, this.m_20193_().f_46441_, 0.5f);
        }
        if (this.m_5912_() && this.playAttackSound) {
            this.playAttackSound = false;
            this.m_20193_().m_5594_(null, this.m_20183_(), TGSounds.GHOULING_ATTACK.get(), SoundSource.HOSTILE, 1.0f, -2.0f);
        }
        if (this.getTeleportTimer() > 0) {
            if (this.getTeleportTimer() == 10) {
                this.m_5496_(SoundEvents.f_12404_, 2.0f, -10.0f);
            }
            MathUtil.createParticleCircle(this.m_20193_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0, 1.5f, TGParticles.GRAVEYARD_SOUL_PARTICLE, this.m_20193_().f_46441_, 0.5f);
            MathUtil.createParticleCircle(this.m_20193_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0, 1.5f, ParticleTypes.f_123745_, this.m_20193_().f_46441_, 0.5f);
        }
        super.m_8107_();
    }

    public void m_8119_() {
        if (this.getSpawnTimer() > 0 && this.m_20193_() != null) {
            RandomSource random = this.m_217043_();
            BlockState blockState = this.m_20075_();
            if (blockState.m_60799_() != RenderShape.INVISIBLE) {
                for (int i = 0; i < 30; ++i) {
                    double d = this.m_20185_() + (double)Mth.m_216283_((RandomSource)random, (float)-0.7f, (float)0.7f);
                    double e = this.m_20186_();
                    double f = this.m_20189_() + (double)Mth.m_216283_((RandomSource)random, (float)-0.7f, (float)0.7f);
                    this.m_20193_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), d, e, f, 0.0, 0.0, 0.0);
                }
            }
        }
        super.m_8119_();
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimationState(int state) {
        this.f_19804_.m_135381_(ANIMATION, (Object)state);
    }

    public int getAttackAnimTimer() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_ANIM_TIMER);
    }

    public void setAttackAnimTimer(int time) {
        this.f_19804_.m_135381_(ATTACK_ANIM_TIMER, (Object)time);
    }

    public int getTeleportTimer() {
        return (Integer)this.f_19804_.m_135370_(TELEPORT_TIMER);
    }

    public void setTeleportTimer(int time) {
        this.f_19804_.m_135381_(TELEPORT_TIMER, (Object)time);
    }

    public void onSummoned() {
        this.setAnimationState(0);
        this.setSpawnTimer(50);
    }

    public boolean m_6785_(double distanceSquared) {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animationData) {
        animationData.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, event -> {
            if (this.getAnimationState() == 0 && this.getSpawnTimer() >= 0) {
                event.getController().setAnimation(this.SPAWN_ANIMATION);
                return PlayState.CONTINUE;
            }
            return PlayState.CONTINUE;
        })});
        animationData.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller2", 0, event -> {
            if (this.m_21224_() || (double)this.m_21223_() < 0.01) {
                event.getController().setAnimation(this.DEATH_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 2 && this.getAttackAnimTimer() == 13 && this.m_5912_() && !this.m_21224_() && !((double)this.m_21223_() < 0.01)) {
                this.setAttackAnimTimer(12);
                event.getController().setAnimation(this.ATTACK_ANIMATION);
                return PlayState.CONTINUE;
            }
            if ((this.getAnimationState() == 3 || event.isMoving()) && this.getAttackAnimTimer() <= 0) {
                event.getController().setAnimation(this.WALK_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 1 && this.getAttackAnimTimer() <= 0 && this.getSpawnTimer() <= 0) {
                event.getController().setAnimation(this.IDLE_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 1 && this.getAttackAnimTimer() > 0) {
                this.setAnimationState(2);
                return PlayState.STOP;
            }
            if (this.getAttackAnimTimer() <= 0 && !this.m_21224_() && !((double)this.m_21223_() < 0.01) && this.getSpawnTimer() <= 0) {
                this.setAnimationState(1);
                return PlayState.STOP;
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!this.m_20193_().m_5776_() && this.isOwner((LivingEntity)player)) {
            if (this.hasCoffin() && player.m_6144_()) {
                player.m_5893_((MenuProvider)this);
                return InteractionResult.SUCCESS;
            }
            if (!itemStack.m_41619_() && !this.hasCoffin() && GHOULING_HOLDABLE.contains(itemStack.m_41720_())) {
                this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)itemStack.m_41720_()));
                if (this.inventory == null) {
                    this.m_5496_(SoundEvents.f_11747_, 1.0f, -5.0f);
                    TGAdvancements.EQUIP_COFFIN.trigger((ServerPlayer)player);
                    this.inventory = new SimpleContainer(54);
                    this.setHasCoffin(true);
                }
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_41720_() instanceof BoneStaffItem && !player.m_6144_()) {
                InteractionResult actionResult = super.m_6071_(player, hand);
                if (!actionResult.m_19077_()) {
                    this.m_5496_(TGSounds.GHOULING_GROAN.get(), 1.0f, -2.0f);
                    if (this.isInSittingPose()) {
                        player.m_5661_((Component)Component.m_237115_((String)"entity.graveyard.ghouling.nowait"), true);
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"entity.graveyard.ghouling.wait"), true);
                    }
                    this.setSitting(!this.isSitting());
                    this.f_20899_ = false;
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    return InteractionResult.SUCCESS;
                }
                return actionResult;
            }
        }
        return super.m_6071_(player, hand);
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 44 && !this.m_20193_().m_5776_()) {
            this.m_20193_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public int getSpawnTimer() {
        return (Integer)this.f_19804_.m_135370_(SPAWN_TIMER);
    }

    public void setSpawnTimer(int ticks) {
        this.f_19804_.m_135381_(SPAWN_TIMER, (Object)ticks);
    }

    public byte getVariant() {
        return (Byte)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(byte variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public ItemStack getStaff() {
        return (ItemStack)this.f_19804_.m_135370_(STAFF);
    }

    public void setStaff(ItemStack staff) {
        this.f_19804_.m_135381_(STAFF, (Object)staff);
    }

    public boolean hasCoffin() {
        return (Boolean)this.f_19804_.m_135370_(COFFIN);
    }

    public void setHasCoffin(boolean hasCoffin) {
        this.f_19804_.m_135381_(COFFIN, (Object)hasCoffin);
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.hasCoffin()) {
            if (!this.m_20193_().f_46443_) {
                this.m_19998_((ItemLike)this.m_21206_().m_41720_());
                if (this.inventory != null) {
                    for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                        ItemStack stack = this.inventory.m_8020_(i);
                        if (stack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)stack)) continue;
                        this.m_19983_(stack);
                    }
                }
            }
            this.setHasCoffin(false);
        }
    }

    public void m_6667_(DamageSource damageSource) {
        if (!this.m_20193_().m_5776_()) {
            BoneStaffItem.ownerGhoulingMapping.remove(this.m_20148_(), this.getOwnerUuid());
        }
        super.m_6667_(damageSource);
        this.m_5496_(TGSounds.GHOULING_DEATH.get(), 1.0f, -2.0f);
    }

    public void m_8032_() {
        this.m_5496_(TGSounds.GHOULING_AMBIENT.get(), 1.0f, -1.0f);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(TGSounds.GHOULING_STEP.get(), 0.3f, 0.0f);
    }

    protected void m_6677_(DamageSource source) {
        this.m_5496_(TGSounds.GHOULING_HURT.get(), 1.0f, -1.0f);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("CoffinGhouling", this.hasCoffin());
        nbt.m_128344_("ghoulVariant", this.getVariant());
        if (this.getStaff() != null) {
            nbt.m_128365_("Staff", (Tag)this.getStaff().m_41739_(new CompoundTag()));
        }
        if (this.inventory != null) {
            ListTag inv = new ListTag();
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                inv.add((Object)this.inventory.m_8020_(i).m_41739_(new CompoundTag()));
            }
            nbt.m_128365_("Inventory", (Tag)inv);
        }
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setHasCoffin(nbt.m_128471_("CoffinGhouling"));
        this.setVariant(nbt.m_128445_("ghoulVariant"));
        if (nbt.m_128441_("Staff")) {
            this.setStaff(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Staff")));
        }
        if (nbt.m_128441_("Inventory")) {
            ListTag inv = nbt.m_128437_("Inventory", 10);
            this.inventory = new SimpleContainer(inv.size());
            for (int i = 0; i < inv.size(); ++i) {
                this.inventory.m_6836_(i, ItemStack.m_41712_((CompoundTag)inv.m_128728_(i)));
            }
        }
    }

    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        if (this.inventory == null) {
            return null;
        }
        return ChestMenu.m_39246_((int)syncId, (Inventory)inv, (Container)this.inventory);
    }

    static {
        GHOULING_HOLDABLE = new ArrayList<Item>();
        GHOULING_HOLDABLE.add(TGBlocks.SARCOPHAGUS.get().m_5456_());
        for (Block coffin : TGBlocks.coffins) {
            GHOULING_HOLDABLE.add(coffin.m_5456_());
        }
        ATTACK_ANIM_TIMER = SynchedEntityData.m_135353_(GhoulingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        ANIMATION = SynchedEntityData.m_135353_(GhoulingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        SPAWN_TIMER = SynchedEntityData.m_135353_(GhoulingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        TELEPORT_TIMER = SynchedEntityData.m_135353_(GhoulingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        COFFIN = SynchedEntityData.m_135353_(GhoulingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        VARIANT = SynchedEntityData.m_135353_(GhoulingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
        STAFF = SynchedEntityData.m_135353_(GhoulingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    }

    class GhoulingEscapeDangerGoal
    extends PanicGoal {
        public GhoulingEscapeDangerGoal(double speed) {
            super((PathfinderMob)GhoulingEntity.this, speed);
        }

        protected boolean m_202729_() {
            return this.f_25684_.m_203117_() || this.f_25684_.m_6060_();
        }
    }
}

