/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.recipe;

import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderContainer;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolPartsHook;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tables.TinkerTables;

public class PartBuilderToolRecycle
implements IPartBuilderRecipe {
    private static final Component TOOL_RECYCLING = TConstruct.makeTranslation("recipe", "tool_recycling");
    private static final List<Component> INSTRUCTIONS = Collections.singletonList(TConstruct.makeTranslation("recipe", "tool_recycling.info"));
    private static final List<Component> NO_MODIFIERS = Collections.singletonList(TConstruct.makeTranslation("recipe", "tool_recycling.no_modifiers").m_130940_(ChatFormatting.RED));
    public static final SizedIngredient DEFAULT_TOOLS = SizedIngredient.fromTag(TinkerTags.Items.MULTIPART_TOOL);
    public static final RecordLoadable<PartBuilderToolRecycle> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)SizedIngredient.LOADABLE.defaultField("tools", (Object)DEFAULT_TOOLS, true, r -> r.toolRequirement), (RecordField)IngredientLoadable.DISALLOW_EMPTY.requiredField("pattern", r -> r.pattern), (RecordField)TinkerLoadables.MATERIAL_ITEM.list(0).defaultField("parts", List.of(), r -> r.parts), PartBuilderToolRecycle::new);
    private static final Pattern ERROR = new Pattern("tconstruct", "missingno");
    private final ResourceLocation id;
    private final SizedIngredient toolRequirement;
    private final Ingredient pattern;
    private final List<IMaterialItem> parts;

    @Deprecated(forRemoval=true)
    public PartBuilderToolRecycle(ResourceLocation id, SizedIngredient toolRequirement, Ingredient pattern) {
        this(id, toolRequirement, pattern, List.of());
    }

    @Override
    public Pattern getPattern() {
        return ERROR;
    }

    @Override
    public Stream<Pattern> getPatterns(IPartBuilderContainer inv) {
        Item item;
        List<IMaterialItem> parts = this.parts;
        if (parts.isEmpty() && (item = inv.getStack().m_41720_()) instanceof IModifiable) {
            IModifiable modifiable = (IModifiable)item;
            parts = ToolPartsHook.parts(modifiable.getToolDefinition());
        }
        return parts.stream().map(part -> BuiltInRegistries.f_257033_.m_7981_((Object)part.m_5456_())).distinct().map(Pattern::new);
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public int getItemsUsed(IPartBuilderContainer inv) {
        return this.toolRequirement.getAmountNeeded();
    }

    @Override
    public boolean partialMatch(IPartBuilderContainer inv) {
        return this.pattern.test(inv.getPatternStack()) && this.toolRequirement.test(inv.getStack());
    }

    public boolean matches(IPartBuilderContainer inv, Level pLevel) {
        return this.partialMatch(inv) && ToolStack.from(inv.getStack()).getUpgrades().isEmpty();
    }

    @Override
    public ItemStack assemble(IPartBuilderContainer inv, RegistryAccess access, Pattern pattern) {
        ToolStack tool = ToolStack.from(inv.getStack());
        ToolDefinition definition = tool.getDefinition();
        List<IMaterialItem> parts = this.parts;
        if (parts.isEmpty()) {
            parts = ToolPartsHook.parts(definition);
        }
        int materials = Math.min(ToolMaterialHook.stats(definition).size(), parts.size());
        IMaterialItem match = null;
        int matchIndex = -1;
        for (int i = 0; i < materials; ++i) {
            IMaterialItem part = parts.get(i);
            if (!pattern.equals(BuiltInRegistries.f_257033_.m_7981_((Object)part.m_5456_()))) continue;
            matchIndex = i;
            match = part;
            break;
        }
        if (match == null) {
            return ItemStack.f_41583_;
        }
        MaterialVariantId variant = tool.getMaterial(matchIndex).getVariant();
        if (!match.canUseMaterial(variant.getId())) {
            return ItemStack.f_41583_;
        }
        return match.withMaterial(variant);
    }

    @Override
    public ItemStack getLeftover(IPartBuilderContainer inv, Pattern pattern) {
        int max;
        ToolStack tool = ToolStack.from(inv.getStack());
        int damage = tool.getDamage();
        if (damage > 0 && TConstruct.RANDOM.nextInt(max = tool.getStats().getInt(ToolStats.DURABILITY)) < damage) {
            return ItemStack.f_41583_;
        }
        ToolDefinition definition = tool.getDefinition();
        List<IMaterialItem> requirements = this.parts;
        if (requirements.isEmpty()) {
            requirements = ToolPartsHook.parts(definition);
        }
        int materials = Math.min(ToolMaterialHook.stats(definition).size(), requirements.size());
        IntArrayList indices = new IntArrayList();
        boolean found = false;
        ArrayList<IMaterialItem> parts = new ArrayList<IMaterialItem>();
        for (int i = 0; i < materials; ++i) {
            IMaterialItem part = requirements.get(i);
            if (found || !pattern.equals(BuiltInRegistries.f_257033_.m_7981_((Object)part.m_5456_()))) {
                parts.add(part);
                indices.add(i);
                continue;
            }
            found = true;
        }
        if (parts.isEmpty()) {
            return ItemStack.f_41583_;
        }
        int index = TConstruct.RANDOM.nextInt(parts.size());
        return ((IMaterialItem)parts.get(index)).withMaterial(tool.getMaterial(indices.getInt(index)).getVariant());
    }

    @Deprecated
    public ItemStack m_8043_(RegistryAccess access) {
        return ItemStack.f_41583_;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.partBuilderToolRecycling.get();
    }

    @Override
    @Nullable
    public Component getTitle() {
        return TOOL_RECYCLING;
    }

    @Override
    public List<Component> getText(IPartBuilderContainer inv) {
        return ModifierUtil.hasUpgrades(inv.getStack()) ? NO_MODIFIERS : INSTRUCTIONS;
    }

    public PartBuilderToolRecycle(ResourceLocation id, SizedIngredient toolRequirement, Ingredient pattern, List<IMaterialItem> parts) {
        this.id = id;
        this.toolRequirement = toolRequirement;
        this.pattern = pattern;
        this.parts = parts;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Deprecated(forRemoval=true)
    public static final class Finished
    extends Record
    implements FinishedRecipe {
        private final ResourceLocation getId;
        private final SizedIngredient tools;
        private final Ingredient pattern;

        public Finished(ResourceLocation getId, SizedIngredient tools, Ingredient pattern) {
            this.getId = getId;
            this.tools = tools;
            this.pattern = pattern;
        }

        public void m_7917_(JsonObject json) {
            json.add("tools", SizedIngredient.LOADABLE.serialize((Object)this.tools));
            json.add("pattern", this.pattern.m_43942_());
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)TinkerTables.partBuilderToolRecycling.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Finished.class, "getId;tools;pattern", "getId", "tools", "pattern"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Finished.class, "getId;tools;pattern", "getId", "tools", "pattern"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Finished.class, "getId;tools;pattern", "getId", "tools", "pattern"}, this, o);
        }

        public ResourceLocation m_6445_() {
            return this.getId;
        }

        public SizedIngredient tools() {
            return this.tools;
        }

        public Ingredient pattern() {
            return this.pattern;
        }
    }
}

