/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.screen.module;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.screen.ScalableElementScreen;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.smeltery.block.entity.module.FuelModule;
import slimeknights.tconstruct.smeltery.client.screen.IScreenWithFluidTank;
import slimeknights.tconstruct.smeltery.client.screen.module.ClickableTankModule;

public class GuiFuelModule
implements IScreenWithFluidTank,
ClickableTankModule {
    private static final String TOOLTIP_TEMPERATURE = TConstruct.makeTranslationKey("gui", "melting.fuel.temperature");
    private static final List<Component> TOOLTIP_NO_TANK = Collections.singletonList(Component.m_237115_((String)TConstruct.makeTranslationKey("gui", "melting.fuel.no_tank")));
    private static final List<Component> TOOLTIP_NO_FUEL = Collections.singletonList(Component.m_237115_((String)TConstruct.makeTranslationKey("gui", "melting.fuel.empty")));
    private static final Component TOOLTIP_INVALID_FUEL = Component.m_237115_((String)TConstruct.makeTranslationKey("gui", "melting.fuel.invalid")).m_130940_(ChatFormatting.RED);
    private static final Component TOOLTIP_SOLID_FUEL = Component.m_237115_((String)TConstruct.makeTranslationKey("gui", "melting.fuel.solid"));
    private final AbstractContainerScreen<?> screen;
    private final FuelModule fuelModule;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final Rect2i fluidLoc;
    private final int fireX;
    private final int fireY;
    private final boolean hasFuelSlot;
    private final ScalableElementScreen fire;
    private FuelModule.FuelInfo fuelInfo = FuelModule.FuelInfo.EMPTY;

    public GuiFuelModule(AbstractContainerScreen<?> screen, FuelModule fuelModule, int x, int y, int width, int height, int fireX, int fireY, boolean hasFuelSlot, ResourceLocation background) {
        this.screen = screen;
        this.fuelModule = fuelModule;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.fluidLoc = new Rect2i(x - 1, y - 1, width + 2, height + 2);
        this.fireX = fireX;
        this.fireY = fireY;
        this.hasFuelSlot = hasFuelSlot;
        this.fire = GuiFuelModule.makeFire(background);
    }

    @Override
    public AbstractContainerMenu getMenu() {
        return this.screen.m_6262_();
    }

    @Override
    public boolean isHovered(int checkX, int checkY) {
        return GuiUtil.isHovered(checkX, checkY, this.x - 1, this.y - 1, this.width + 2, this.height + 2);
    }

    private int getFluidHeight() {
        int capacity = this.fuelInfo.getCapacity();
        if (capacity == 0) {
            return this.height;
        }
        return this.height * this.fuelInfo.getTotalAmount() / capacity;
    }

    @Override
    public boolean isFluidHovered(int checkY) {
        return checkY > this.y + this.height - this.getFluidHeight();
    }

    public void draw(GuiGraphics graphics) {
        int fuel = this.fuelModule.getFuel();
        int fuelQuality = this.fuelModule.getFuelQuality();
        if (fuel > 0 && fuelQuality > 0) {
            this.fire.drawScaledYUp(graphics, this.fireX + this.screen.f_97735_, this.fireY + this.screen.f_97736_, 14 * fuel / fuelQuality);
        }
        if (!this.hasFuelSlot) {
            this.fuelInfo = this.fuelModule.getFuelInfo();
            if (!this.fuelInfo.isEmpty()) {
                GuiUtil.renderFluidTank(graphics.m_280168_(), this.screen, this.fuelInfo.getFluid(), this.fuelInfo.getTotalAmount(), this.fuelInfo.getCapacity(), this.x, this.y, this.width, this.height, 100);
            }
        }
    }

    public void renderHighlight(GuiGraphics graphics, int checkX, int checkY) {
        if (this.isHovered(checkX, checkY)) {
            if (this.hasFuelSlot) {
                if (checkY > this.y + 18) {
                    GuiUtil.renderHighlight(graphics, this.x, this.y + 18, this.width, this.height - 18);
                }
            } else {
                GuiUtil.renderHighlight(graphics, this.x, this.y, this.width, this.height);
            }
        }
    }

    public void addTooltip(GuiGraphics graphics, int mouseX, int mouseY, boolean hasTank) {
        int checkX = mouseX - this.screen.f_97735_;
        int checkY = mouseY - this.screen.f_97736_;
        if (this.isHovered(checkX, checkY)) {
            List<Object> tooltip;
            if (this.hasFuelSlot || this.fuelInfo.isItem()) {
                int temperature;
                tooltip = !this.hasFuelSlot || checkY > this.y + 18 ? (hasTank ? ((temperature = this.fuelModule.getTemperature()) > 0 ? Arrays.asList(TOOLTIP_SOLID_FUEL, Component.m_237110_((String)TOOLTIP_TEMPERATURE, (Object[])new Object[]{temperature}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC})) : TOOLTIP_NO_FUEL) : TOOLTIP_NO_TANK) : Collections.emptyList();
            } else if (!this.fuelInfo.isEmpty()) {
                FluidStack fluid = this.fuelInfo.getFluid();
                tooltip = FluidTooltipHandler.getFluidTooltip((FluidStack)fluid, (int)this.fuelInfo.getTotalAmount());
                int temperature = this.fuelInfo.getTemperature();
                if (temperature > 0) {
                    tooltip.add(1, (Component)Component.m_237110_((String)TOOLTIP_TEMPERATURE, (Object[])new Object[]{temperature}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                } else {
                    tooltip.add(1, TOOLTIP_INVALID_FUEL);
                }
            } else {
                tooltip = hasTank ? TOOLTIP_NO_FUEL : TOOLTIP_NO_TANK;
            }
            graphics.m_280666_(this.screen.f_96547_, tooltip, mouseX, mouseY);
        }
    }

    @Override
    @Nullable
    public IScreenWithFluidTank.FluidLocation getFluidUnderMouse(int checkX, int checkY) {
        if (!this.hasFuelSlot && this.isHovered(checkX, checkY) && !this.fuelInfo.isEmpty()) {
            return new IScreenWithFluidTank.FluidLocation(this.fuelInfo.getFluid(), this.fluidLoc);
        }
        return null;
    }

    public static ScalableElementScreen makeFire(ResourceLocation background) {
        return new ScalableElementScreen(background, 176, 136, 14, 14, 256, 256);
    }
}

