/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.fluid.FluidTransferHelper;
import slimeknights.mantle.inventory.SingleItemHandler;
import slimeknights.tconstruct.common.network.InventorySlotSyncPacket;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectManager;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffects;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.particle.FluidParticleData;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.entity.ITankBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.component.TankBlockEntity;
import slimeknights.tconstruct.tools.entity.FluidEffectProjectile;

public class FluidCannonBlockEntity
extends TankBlockEntity
implements ITankBlockEntity.ITankInventoryBlockEntity {
    private final IFluidCannon block;
    private final FluidCannonItemHandler itemHandler;
    private final LazyOptional<IItemHandler> itemCapability;
    private static final String TAG_ITEM = "item";

    public FluidCannonBlockEntity(BlockPos pos, BlockState state) {
        IFluidCannon tank;
        Block block = state.m_60734_();
        this(pos, state, block instanceof IFluidCannon ? (tank = (IFluidCannon)block) : (IFluidCannon)TinkerSmeltery.searedFluidCannon.get());
    }

    public FluidCannonBlockEntity(BlockPos pos, BlockState state, IFluidCannon block) {
        this((BlockEntityType)TinkerSmeltery.fluidCannon.get(), pos, state, block);
    }

    protected FluidCannonBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, IFluidCannon block) {
        super(type, pos, state, block);
        this.itemHandler = new FluidCannonItemHandler();
        this.itemCapability = LazyOptional.of(() -> this.itemHandler);
        this.block = block;
    }

    public void interact(Player player, InteractionHand hand, boolean clickedTank) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (clickedTank) {
            if (!FluidTransferHelper.interactWithContainer((Level)this.f_58857_, (BlockPos)this.f_58858_, (IFluidHandler)this.tank, (Player)player, (InteractionHand)hand).didTransfer()) {
                FluidTransferHelper.interactWithFilledBucket((Level)this.f_58857_, (BlockPos)this.f_58858_, (IFluidHandler)this.tank, (Player)player, (InteractionHand)hand, (Direction)((Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_)));
            }
        } else {
            ItemStack held = player.m_21120_(hand);
            ItemStack inventory = this.itemHandler.getStack();
            if (inventory.m_41619_()) {
                if (!held.m_41619_()) {
                    this.itemHandler.setStack(held);
                    player.m_21008_(hand, ItemStack.f_41583_);
                }
            } else if (held.m_41619_()) {
                player.m_21008_(hand, inventory);
                this.itemHandler.setStack(ItemStack.f_41583_);
            } else {
                inventory = inventory.m_41777_();
                player.m_36356_(inventory);
                this.itemHandler.setStack(inventory);
            }
        }
    }

    public void shoot(BlockState state, ServerLevel level, RandomSource random) {
        FluidEffects recipe;
        FluidStack fluid = this.tank.getFluid();
        if (!fluid.isEmpty() && (recipe = FluidEffectManager.INSTANCE.find(fluid.getFluid())).hasEffects()) {
            float power = this.block.getPower();
            Direction facing = (Direction)state.m_61143_((Property)DirectionalBlock.f_52588_);
            BlockPos target = this.f_58858_.m_121945_(facing);
            BlockState targetState = level.m_8055_(target);
            if (recipe.hasBlockEffects() && !targetState.m_60808_((BlockGetter)level, target).m_83281_()) {
                BlockHitResult hit = Util.createTraceResult(target, facing.m_122424_(), false);
                ItemStack stack = this.itemHandler.getStack().m_41777_();
                int consumed = recipe.applyToBlock(fluid, power, FluidEffectContext.builder((Level)level).stack(stack).block(hit), IFluidHandler.FluidAction.EXECUTE);
                if (consumed > 0) {
                    Vec3 location = hit.m_82450_();
                    level.m_8767_((ParticleOptions)new FluidParticleData((ParticleType<FluidParticleData>)((ParticleType)TinkerCommons.fluidParticle.get()), fluid), location.m_7096_(), location.m_7098_(), location.m_7094_(), 10, 0.1, 0.2, 0.1, 0.2);
                    fluid.shrink(consumed);
                    this.tank.setFluid(fluid);
                    this.tank.onContentsChanged();
                    this.itemHandler.setStack(stack);
                    level.m_46796_(2000, this.f_58858_, facing.m_122411_());
                    return;
                }
            }
            if (!targetState.m_60783_((BlockGetter)level, target, facing.m_122424_())) {
                int amount = Math.min(fluid.getAmount(), (int)((float)recipe.getAmount(fluid.getFluid()) * power));
                FluidEffectProjectile projectile = new FluidEffectProjectile((Level)level, this.f_58858_, facing, new FluidStack(fluid, amount), power);
                projectile.m_6686_(facing.m_122429_(), (float)facing.m_122430_() + 0.1f, facing.m_122431_(), this.block.getVelocity(), this.block.getInaccuracy());
                level.m_7967_((Entity)projectile);
                level.m_6263_(null, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), SoundEvents.f_12098_, SoundSource.BLOCKS, 1.0f, 1.0f / (random.m_188501_() * 0.4f + 1.2f) + 0.5f);
                fluid.shrink(amount);
                this.tank.setFluid(fluid);
                this.tank.onContentsChanged();
                level.m_46796_(2000, this.f_58858_, facing.m_122411_());
                return;
            }
        }
        level.m_46796_(1001, this.f_58858_, 0);
        level.m_220407_(GameEvent.f_223702_, this.f_58858_, GameEvent.Context.m_223722_((BlockState)state));
    }

    @Nonnull
    public <C> LazyOptional<C> getCapability(Capability<C> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemCapability.invalidate();
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.tank.readFromNBT(tag.m_128469_("tank"));
        if (tag.m_128425_(TAG_ITEM, 10)) {
            this.itemHandler.readFromNBT(tag.m_128469_(TAG_ITEM));
        }
    }

    @Override
    public void saveSynced(CompoundTag tag) {
        super.saveSynced(tag);
        tag.m_128365_(TAG_ITEM, (Tag)this.itemHandler.writeToNBT());
    }

    public FluidCannonItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public static interface IFluidCannon
    extends TankBlockEntity.ITankBlock {
        public float getPower();

        public float getVelocity();

        public float getInaccuracy();
    }

    private class FluidCannonItemHandler
    extends SingleItemHandler<FluidCannonBlockEntity> {
        public FluidCannonItemHandler() {
            super((MantleBlockEntity)FluidCannonBlockEntity.this, 64);
        }

        protected boolean isItemValid(ItemStack stack) {
            return true;
        }

        public void setStack(ItemStack newStack) {
            Level world = ((FluidCannonBlockEntity)this.parent).m_58904_();
            boolean hasChange = world != null && !world.f_46443_ && !ItemStack.m_41728_((ItemStack)this.getStack(), (ItemStack)newStack);
            super.setStack(newStack);
            if (hasChange) {
                BlockPos pos = ((FluidCannonBlockEntity)this.parent).m_58899_();
                TinkerNetwork.getInstance().sendToClientsAround(new InventorySlotSyncPacket(newStack, 0, pos), (LevelAccessor)world, pos);
            }
        }
    }
}

