/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.hook.behavior;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public interface AttributesModifierHook {
    public static final UUID[] HELD_ARMOR_UUID = new UUID[]{UUID.fromString("00a1a5fe-43b5-4849-8660-de9aa497736a"), UUID.fromString("6776fd7e-4b22-4cdf-a0bc-bb8d2ad1f0bf")};

    public void addAttributes(IToolStackView var1, ModifierEntry var2, EquipmentSlot var3, BiConsumer<Attribute, AttributeModifier> var4);

    public static Multimap<Attribute, AttributeModifier> getHeldAttributeModifiers(IToolStackView tool, EquipmentSlot slot) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (!tool.isBroken()) {
            StatsNBT statsNBT = tool.getStats();
            if (slot == EquipmentSlot.MAINHAND && tool.hasTag(TinkerTags.Items.MELEE_WEAPON)) {
                builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(Item.f_41374_, "tconstruct.tool.attack_damage", (double)statsNBT.get(ToolStats.ATTACK_DAMAGE).floatValue(), AttributeModifier.Operation.ADDITION));
                builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(Item.f_41375_, "tconstruct.tool.attack_speed", (double)statsNBT.get(ToolStats.ATTACK_SPEED).floatValue() - 4.0, AttributeModifier.Operation.ADDITION));
            }
            if (slot.m_20743_() == EquipmentSlot.Type.HAND) {
                if (tool.hasTag(TinkerTags.Items.ARMOR)) {
                    UUID uuid = HELD_ARMOR_UUID[slot.m_20749_()];
                    double value = statsNBT.get(ToolStats.ARMOR).floatValue();
                    if (value != 0.0) {
                        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "tconstruct.held.armor", value, AttributeModifier.Operation.ADDITION));
                    }
                    if ((value = (double)statsNBT.get(ToolStats.ARMOR_TOUGHNESS).floatValue()) != 0.0) {
                        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "tconstruct.held.toughness", value, AttributeModifier.Operation.ADDITION));
                    }
                    if ((value = (double)statsNBT.get(ToolStats.KNOCKBACK_RESISTANCE).floatValue()) != 0.0) {
                        builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "tconstruct.held.knockback_resistance", value, AttributeModifier.Operation.ADDITION));
                    }
                }
                BiConsumer<Attribute, AttributeModifier> attributeConsumer = (arg_0, arg_1) -> ((ImmutableMultimap.Builder)builder).put(arg_0, arg_1);
                for (ModifierEntry entry : tool.getModifierList()) {
                    entry.getHook(ModifierHooks.ATTRIBUTES).addAttributes(tool, entry, slot, attributeConsumer);
                }
            }
        }
        return builder.build();
    }

    public record AllMerger(Collection<AttributesModifierHook> modules) implements AttributesModifierHook
    {
        @Override
        public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
            for (AttributesModifierHook module : this.modules) {
                module.addAttributes(tool, modifier, slot, consumer);
            }
        }
    }
}

