/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.item;

import com.oblivioussp.spartanshields.client.ClientHelper;
import com.oblivioussp.spartanshields.config.Config;
import com.oblivioussp.spartanshields.item.ShieldBaseItem;
import com.oblivioussp.spartanshields.util.TierSS;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class BasicShieldItem
extends ShieldBaseItem {
    protected final TierSS material;
    protected boolean doCraftCheck = true;
    protected boolean canBeCrafted = true;

    public BasicShieldItem(TierSS toolMaterial, int defaultMaxDamage, boolean isTowerShieldIn, Item.Properties prop) {
        super(defaultMaxDamage, isTowerShieldIn, prop);
        this.material = toolMaterial;
        if (FMLEnvironment.dist.isClient()) {
            ClientHelper.registerShieldPropertyOverrides(this);
        }
    }

    public BasicShieldItem(TierSS toolMaterial, int defaultMaxDamage, Item.Properties prop) {
        this(toolMaterial, defaultMaxDamage, false, prop);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.spartanshields.protection", (Object[])new Object[]{this.getMaxDamage(stack)}));
        if (this.doCraftCheck && levelIn != null) {
            ITagManager tagManager;
            if (!(((Boolean)Config.INSTANCE.forceDisableUncraftableTooltips.get()).booleanValue() || (tagManager = ForgeRegistries.ITEMS.tags()).isKnownTagName(this.material.getRepairTag()) && !tagManager.getTag(this.material.getRepairTag()).isEmpty())) {
                this.canBeCrafted = false;
            }
            this.doCraftCheck = false;
        }
        if (!this.canBeCrafted) {
            tooltip.add((Component)Component.m_237110_((String)String.format("tooltip.%s.uncraftable_missing_material", "spartanshields"), (Object[])new Object[]{this.material.getRepairTagName()}).m_130940_(ChatFormatting.RED));
        }
        super.m_7373_(stack, levelIn, tooltip, flagIn);
    }

    public int m_6473_() {
        return this.material.m_6601_();
    }

    @Override
    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return this.material.m_6282_().test(repair) || super.m_6832_(toRepair, repair);
    }
}

