/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.world.level.block.plant.branch.BranchBlock;
import net.regions_unexplored.world.level.block.plant.other.SpanishMossBlock;
import net.regions_unexplored.world.level.feature.configuration.RuTreeConfiguration;

public class CypressTreeFeature
extends Feature<RuTreeConfiguration> {
    public CypressTreeFeature(Codec<RuTreeConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<RuTreeConfiguration> context) {
        RuTreeConfiguration treeConfiguration = (RuTreeConfiguration)context.m_159778_();
        BlockPos pos = context.m_159777_();
        RandomSource randomSource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        boolean hasVines = false;
        if (randomSource.m_188503_(3) == 0) {
            hasVines = true;
        }
        int height_main = context.m_225041_().m_188503_(treeConfiguration.sizeVariation) + treeConfiguration.minimumSize;
        BlockPos.MutableBlockPos checkPos = pos.m_122032_();
        for (int check = 0; check <= height_main; ++check) {
            if (!this.checkReplaceable((LevelAccessor)level, (BlockPos)checkPos)) {
                return false;
            }
            checkPos.m_122173_(Direction.UP);
        }
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        for (int placeCheck = 0; placeCheck <= height_main; ++placeCheck) {
            this.placeLog((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y);
            if (placeCheck > 1) {
                this.placeBranchDecorator((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            if (placeCheck == 0) {
                this.placeRoot((LevelAccessor)level, placePos.m_7495_().m_122012_(), randomSource, treeConfiguration);
                this.placeLog((LevelAccessor)level, placePos.m_122012_(), randomSource, treeConfiguration, Direction.Axis.Y);
                if (randomSource.m_188503_(2) == 0) {
                    this.placeLog((LevelAccessor)level, placePos.m_7494_().m_122012_(), randomSource, treeConfiguration, Direction.Axis.Y);
                    if (randomSource.m_188503_(2) == 0) {
                        this.placeLog((LevelAccessor)level, placePos.m_6630_(2).m_122012_(), randomSource, treeConfiguration, Direction.Axis.Y);
                    }
                }
                this.placeRoot((LevelAccessor)level, placePos.m_7495_().m_122019_(), randomSource, treeConfiguration);
                this.placeLog((LevelAccessor)level, placePos.m_122019_(), randomSource, treeConfiguration, Direction.Axis.Y);
                if (randomSource.m_188503_(2) == 0) {
                    this.placeLog((LevelAccessor)level, placePos.m_7494_().m_122019_(), randomSource, treeConfiguration, Direction.Axis.Y);
                    if (randomSource.m_188503_(2) == 0) {
                        this.placeLog((LevelAccessor)level, placePos.m_6630_(2).m_122019_(), randomSource, treeConfiguration, Direction.Axis.Y);
                    }
                }
                this.placeRoot((LevelAccessor)level, placePos.m_7495_().m_122029_(), randomSource, treeConfiguration);
                this.placeLog((LevelAccessor)level, placePos.m_122029_(), randomSource, treeConfiguration, Direction.Axis.Y);
                if (randomSource.m_188503_(2) == 0) {
                    this.placeLog((LevelAccessor)level, placePos.m_7494_().m_122029_(), randomSource, treeConfiguration, Direction.Axis.Y);
                    if (randomSource.m_188503_(2) == 0) {
                        this.placeLog((LevelAccessor)level, placePos.m_6630_(2).m_122029_(), randomSource, treeConfiguration, Direction.Axis.Y);
                    }
                }
                this.placeRoot((LevelAccessor)level, placePos.m_7495_().m_122024_(), randomSource, treeConfiguration);
                this.placeLog((LevelAccessor)level, placePos.m_122024_(), randomSource, treeConfiguration, Direction.Axis.Y);
                if (randomSource.m_188503_(2) == 0) {
                    this.placeLog((LevelAccessor)level, placePos.m_7494_().m_122024_(), randomSource, treeConfiguration, Direction.Axis.Y);
                    if (randomSource.m_188503_(2) == 0) {
                        this.placeLog((LevelAccessor)level, placePos.m_6630_(2).m_122024_(), randomSource, treeConfiguration, Direction.Axis.Y);
                    }
                }
                this.placeRoot((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            if (placeCheck == height_main) {
                this.placeTop((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration, hasVines);
            }
            placePos.m_122173_(Direction.UP);
        }
        return true;
    }

    public void placeTop(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration, boolean hasVines) {
        BlockPos.MutableBlockPos placePos = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        this.placeLeavesBlob(level, pos, randomSource, treeConfiguration, hasVines);
        this.placeBranches(level, pos, randomSource, treeConfiguration, hasVines);
    }

    public void placeBranches(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration, boolean hasVines) {
        int type = randomSource.m_188503_(2);
        int[] positions = new int[]{randomSource.m_188503_(2) + 3, randomSource.m_188503_(2) + 6, randomSource.m_188503_(2) + 9, randomSource.m_188503_(2) + 12};
        for (int i = 0; i < positions.length; ++i) {
            int randomIndexToSwap = randomSource.m_188503_(positions.length);
            int temp = positions[randomIndexToSwap];
            positions[randomIndexToSwap] = positions[i];
            positions[i] = temp;
        }
        BlockPos n = new BlockPos(pos.m_123341_(), pos.m_123342_() - positions[0], pos.m_123343_());
        BlockPos s = new BlockPos(pos.m_123341_(), pos.m_123342_() - positions[1], pos.m_123343_());
        BlockPos e = new BlockPos(pos.m_123341_(), pos.m_123342_() - positions[2], pos.m_123343_());
        BlockPos w = new BlockPos(pos.m_123341_(), pos.m_123342_() - positions[3], pos.m_123343_());
        this.placeLog(level, n.m_122012_(), randomSource, treeConfiguration, Direction.Axis.Z);
        this.placeLog(level, n.m_122013_(2), randomSource, treeConfiguration, Direction.Axis.Z);
        this.placeLeavesBlob(level, n.m_122013_(2), randomSource, treeConfiguration, hasVines);
        this.placeLog(level, s.m_122019_(), randomSource, treeConfiguration, Direction.Axis.Z);
        this.placeLog(level, s.m_122020_(2), randomSource, treeConfiguration, Direction.Axis.Z);
        this.placeLeavesBlob(level, s.m_122020_(2), randomSource, treeConfiguration, hasVines);
        this.placeLog(level, e.m_122029_(), randomSource, treeConfiguration, Direction.Axis.X);
        this.placeLog(level, e.m_122030_(2), randomSource, treeConfiguration, Direction.Axis.X);
        this.placeLeavesBlob(level, e.m_122030_(2), randomSource, treeConfiguration, hasVines);
        this.placeLog(level, w.m_122024_(), randomSource, treeConfiguration, Direction.Axis.X);
        this.placeLog(level, w.m_122025_(2), randomSource, treeConfiguration, Direction.Axis.X);
        this.placeLeavesBlob(level, w.m_122025_(2), randomSource, treeConfiguration, hasVines);
    }

    private static void placeVine(LevelAccessor level, BlockPos pos) {
        Random random = new Random();
        int size = random.nextInt(6);
        BlockPos place = pos.m_7495_();
        for (int i = 0; i <= size; ++i) {
            if (level.m_8055_(place).m_60795_()) {
                if (i == size) {
                    level.m_7731_(place, (BlockState)((Block)RuBlocks.SPANISH_MOSS.get()).m_49966_().m_61124_((Property)SpanishMossBlock.f_53924_, (Comparable)Integer.valueOf(25)), 2);
                } else {
                    level.m_7731_(place, ((Block)RuBlocks.SPANISH_MOSS_PLANT.get()).m_49966_(), 2);
                }
            } else {
                if (i == 0) break;
                level.m_7731_(place.m_7494_(), (BlockState)((Block)RuBlocks.SPANISH_MOSS.get()).m_49966_().m_61124_((Property)SpanishMossBlock.f_53924_, (Comparable)Integer.valueOf(25)), 2);
                break;
            }
            place = place.m_7495_();
        }
    }

    public void placeLeavesBlob(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration, boolean hasVines) {
        Random random = new Random();
        int n = random.nextInt(3);
        this.placeLeavesBlock(level, pos.m_7494_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7494_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122030_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122025_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122030_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(2).m_122029_(), randomSource, treeConfiguration);
        if (hasVines) {
            if (randomSource.m_188503_(2) == 0) {
                CypressTreeFeature.placeVine(level, pos.m_122013_(2));
            }
            if (randomSource.m_188503_(2) == 0) {
                CypressTreeFeature.placeVine(level, pos.m_122013_(2).m_122029_());
            }
            if (randomSource.m_188503_(2) == 0) {
                CypressTreeFeature.placeVine(level, pos.m_122013_(2).m_122024_());
            }
            if (randomSource.m_188503_(2) == 0) {
                CypressTreeFeature.placeVine(level, pos.m_122020_(2));
            }
            if (randomSource.m_188503_(2) == 0) {
                CypressTreeFeature.placeVine(level, pos.m_122020_(2).m_122029_());
            }
            if (randomSource.m_188503_(2) == 0) {
                CypressTreeFeature.placeVine(level, pos.m_122020_(2).m_122024_());
            }
            if (randomSource.m_188503_(2) == 0) {
                CypressTreeFeature.placeVine(level, pos.m_122030_(2));
            }
            if (randomSource.m_188503_(2) == 0) {
                CypressTreeFeature.placeVine(level, pos.m_122030_(2).m_122012_());
            }
            if (randomSource.m_188503_(2) == 0) {
                CypressTreeFeature.placeVine(level, pos.m_122030_(2).m_122019_());
            }
            if (randomSource.m_188503_(2) == 0) {
                CypressTreeFeature.placeVine(level, pos.m_122025_(2));
            }
            if (randomSource.m_188503_(2) == 0) {
                CypressTreeFeature.placeVine(level, pos.m_122025_(2).m_122012_());
            }
            if (randomSource.m_188503_(2) == 0) {
                CypressTreeFeature.placeVine(level, pos.m_122025_(2).m_122019_());
            }
        }
        this.placeLeavesBlock(level, pos.m_122012_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122025_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(2).m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122030_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(2).m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122025_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(2).m_122024_(), randomSource, treeConfiguration);
    }

    public boolean placeLog(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration, Direction.Axis axis) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (CypressTreeFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.m_7731_(pos, (BlockState)treeConfiguration.trunkProvider.m_213972_(randomSource, pos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)axis), 2);
        } else {
            return true;
        }
        if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        }
        return true;
    }

    public void placeBranchDecorator(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (randomSource.m_188503_(10) == 0) {
            int rd = random.nextInt(4);
            if (rd == 0) {
                this.placeNorthBranch(level, pos, randomSource, treeConfiguration);
            } else if (rd == 1) {
                this.placeSouthBranch(level, pos, randomSource, treeConfiguration);
            } else if (rd == 2) {
                this.placeEastBranch(level, pos, randomSource, treeConfiguration);
            } else {
                this.placeWestBranch(level, pos, randomSource, treeConfiguration);
            }
        }
    }

    public void placeNorthBranch(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (level.m_8055_(pos.m_122012_()).m_247087_() && !level.m_151570_(pos.m_122012_())) {
            level.m_7731_(pos.m_122012_(), (BlockState)treeConfiguration.branchProvider.m_213972_(randomSource, pos).m_61124_((Property)BranchBlock.FACING, (Comparable)Direction.NORTH), 2);
        }
        if (level.m_8055_(pos.m_122012_().m_7494_()).m_247087_() && !level.m_151570_(pos.m_122012_().m_7494_())) {
            level.m_7731_(pos.m_122012_().m_7494_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122012_().m_122012_()).m_247087_() && !level.m_151570_(pos.m_122012_().m_122012_())) {
            level.m_7731_(pos.m_122012_().m_122012_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122012_().m_122029_()).m_247087_() && !level.m_151570_(pos.m_122012_().m_122029_())) {
            level.m_7731_(pos.m_122012_().m_122029_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122012_().m_122024_()).m_247087_() && !level.m_151570_(pos.m_122012_().m_122024_())) {
            level.m_7731_(pos.m_122012_().m_122024_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    public void placeSouthBranch(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (level.m_8055_(pos.m_122019_()).m_247087_() && !level.m_151570_(pos.m_122019_())) {
            level.m_7731_(pos.m_122019_(), (BlockState)treeConfiguration.branchProvider.m_213972_(randomSource, pos).m_61124_((Property)BranchBlock.FACING, (Comparable)Direction.SOUTH), 2);
        }
        if (level.m_8055_(pos.m_122019_().m_7494_()).m_247087_() && !level.m_151570_(pos.m_122019_().m_7494_())) {
            level.m_7731_(pos.m_122019_().m_7494_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122019_().m_122019_()).m_247087_() && !level.m_151570_(pos.m_122019_().m_122019_())) {
            level.m_7731_(pos.m_122019_().m_122019_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122019_().m_122029_()).m_247087_() && !level.m_151570_(pos.m_122019_().m_122029_())) {
            level.m_7731_(pos.m_122019_().m_122029_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122019_().m_122024_()).m_247087_() && !level.m_151570_(pos.m_122019_().m_122024_())) {
            level.m_7731_(pos.m_122019_().m_122024_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    public void placeEastBranch(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (level.m_8055_(pos.m_122029_()).m_247087_() && !level.m_151570_(pos.m_122029_())) {
            level.m_7731_(pos.m_122029_(), (BlockState)treeConfiguration.branchProvider.m_213972_(randomSource, pos).m_61124_((Property)BranchBlock.FACING, (Comparable)Direction.EAST), 2);
        }
        if (level.m_8055_(pos.m_122029_().m_7494_()).m_247087_() && !level.m_151570_(pos.m_122029_().m_7494_())) {
            level.m_7731_(pos.m_122029_().m_7494_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122029_().m_122029_()).m_247087_() && !level.m_151570_(pos.m_122029_().m_122029_())) {
            level.m_7731_(pos.m_122029_().m_122029_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122029_().m_122019_()).m_247087_() && !level.m_151570_(pos.m_122029_().m_122019_())) {
            level.m_7731_(pos.m_122029_().m_122019_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122029_().m_122012_()).m_247087_() && !level.m_151570_(pos.m_122029_().m_122012_())) {
            level.m_7731_(pos.m_122029_().m_122012_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    public void placeWestBranch(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (level.m_8055_(pos.m_122024_()).m_247087_() && !level.m_151570_(pos.m_122024_())) {
            level.m_7731_(pos.m_122024_(), (BlockState)treeConfiguration.branchProvider.m_213972_(randomSource, pos).m_61124_((Property)BranchBlock.FACING, (Comparable)Direction.WEST), 2);
        }
        if (level.m_8055_(pos.m_122024_().m_7494_()).m_247087_() && !level.m_151570_(pos.m_122024_().m_7494_())) {
            level.m_7731_(pos.m_122024_().m_7494_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122024_().m_122024_()).m_247087_() && !level.m_151570_(pos.m_122024_().m_122024_())) {
            level.m_7731_(pos.m_122024_().m_122024_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122024_().m_122019_()).m_247087_() && !level.m_151570_(pos.m_122024_().m_122019_())) {
            level.m_7731_(pos.m_122024_().m_122019_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122024_().m_122012_()).m_247087_() && !level.m_151570_(pos.m_122024_().m_122012_())) {
            level.m_7731_(pos.m_122024_().m_122012_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    public void placeRoot(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        int rd = random.nextInt(2) + 2;
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        for (int i = 0; i <= rd; ++i) {
            if (level.m_8055_((BlockPos)placePos).m_247087_() && level.m_8055_(placePos.m_7494_()).m_204336_(BlockTags.f_144274_)) {
                level.m_7731_((BlockPos)placePos, Blocks.f_152548_.m_49966_(), 2);
                break;
            }
            if (!level.m_8055_((BlockPos)placePos).m_204336_(BlockTags.f_144274_) && !level.m_8055_((BlockPos)placePos).m_204336_(BlockTags.f_278411_) && !level.m_46859_((BlockPos)placePos)) break;
            this.placeLog(level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y);
            placePos.m_122173_(Direction.DOWN);
        }
    }

    public boolean placeLeavesBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_247087_()) {
            level.m_7731_(pos, (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        return true;
    }

    public boolean checkReplaceable(LevelAccessor level, BlockPos pos) {
        if (level.m_151570_(pos)) {
            return false;
        }
        return CypressTreeFeature.isReplaceable((LevelSimulatedReader)level, pos);
    }

    public static boolean isReplaceableDirtBlock(BlockState state) {
        return state.m_204336_(RuTags.TREE_GRASS_REPLACEABLES);
    }

    public static boolean isReplaceableDirt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, CypressTreeFeature::isReplaceableDirtBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.m_204336_(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, CypressTreeFeature::isReplaceableBlock);
    }
}

