/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;

public class MeadowRockFeature
extends Feature<NoneFeatureConfiguration> {
    public MeadowRockFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos = context.m_159777_();
        RandomSource randomSource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        int height_main = 5;
        int height_1 = randomSource.m_188503_(3);
        int height_2 = randomSource.m_188503_(3);
        int height_3 = randomSource.m_188503_(3);
        int height_4 = randomSource.m_188503_(3);
        BlockPos.MutableBlockPos checkPos = pos.m_122032_();
        for (int check = 0; check <= height_main; ++check) {
            if (!this.checkReplaceable((LevelAccessor)level, (BlockPos)checkPos)) {
                return false;
            }
            checkPos.m_122173_(Direction.UP);
        }
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        for (int placeCheck = 0; placeCheck <= height_main; ++placeCheck) {
            if (placeCheck == 0) {
                this.placeBottom((LevelAccessor)level, (BlockPos)placePos, randomSource);
                this.placeBottom((LevelAccessor)level, placePos.m_122012_(), randomSource);
                this.placeBottom((LevelAccessor)level, placePos.m_122012_().m_122029_(), randomSource);
                this.placeBottom((LevelAccessor)level, placePos.m_122029_(), randomSource);
            }
            if (placeCheck <= height_1) {
                this.placeRandomBlock((LevelAccessor)level, (BlockPos)placePos, randomSource);
                if (placeCheck == height_1) {
                    this.placeMoss((LevelAccessor)level, placePos.m_7494_(), randomSource);
                }
            }
            if (placeCheck <= height_2) {
                this.placeRandomBlock((LevelAccessor)level, placePos.m_122012_(), randomSource);
                if (placeCheck == height_2) {
                    this.placeMoss((LevelAccessor)level, placePos.m_7494_().m_122012_(), randomSource);
                }
            }
            if (placeCheck <= height_3) {
                this.placeRandomBlock((LevelAccessor)level, placePos.m_122012_().m_122029_(), randomSource);
                if (placeCheck == height_3) {
                    this.placeMoss((LevelAccessor)level, placePos.m_7494_().m_122012_().m_122029_(), randomSource);
                }
            }
            if (placeCheck <= height_4) {
                this.placeRandomBlock((LevelAccessor)level, placePos.m_122029_(), randomSource);
                if (placeCheck == height_4) {
                    this.placeMoss((LevelAccessor)level, placePos.m_7494_().m_122029_(), randomSource);
                }
            }
            placePos.m_122173_(Direction.UP);
        }
        return true;
    }

    public boolean placeBottom(LevelAccessor level, BlockPos pos, RandomSource randomSource) {
        Random random = new Random();
        int rd = 2;
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        for (int i = 0; i <= rd; ++i) {
            if (level.m_8055_((BlockPos)placePos).m_247087_() && level.m_8055_(placePos.m_7494_()).m_204336_(BlockTags.f_13106_)) {
                level.m_7731_((BlockPos)placePos, Blocks.f_152548_.m_49966_(), 2);
            }
            this.placeRandomBlock(level, (BlockPos)placePos, randomSource);
            placePos.m_122173_(Direction.DOWN);
        }
        return true;
    }

    public boolean placeRandomBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource) {
        boolean isBase = false;
        if (level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144274_)) {
            isBase = true;
        }
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (MeadowRockFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            if (randomSource.m_188503_(2) == 0) {
                level.m_7731_(pos, Blocks.f_50069_.m_49966_(), 2);
            } else {
                level.m_7731_(pos, ((Block)RuBlocks.MOSSY_STONE.get()).m_49966_(), 2);
            }
        } else {
            return true;
        }
        if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        }
        return true;
    }

    public boolean placeMoss(LevelAccessor level, BlockPos pos, RandomSource randomSource) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_247087_() && level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP) && randomSource.m_188503_(4) == 0) {
            level.m_7731_(pos, Blocks.f_152543_.m_49966_(), 2);
        }
        return true;
    }

    public boolean checkReplaceable(LevelAccessor level, BlockPos pos) {
        if (level.m_151570_(pos)) {
            return false;
        }
        return MeadowRockFeature.isReplaceable((LevelSimulatedReader)level, pos);
    }

    public static boolean isReplaceableDirtBlock(BlockState state) {
        return state.m_204336_(RuTags.TREE_GRASS_REPLACEABLES);
    }

    public static boolean isReplaceableDirt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, MeadowRockFeature::isReplaceableDirtBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.m_204336_(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, MeadowRockFeature::isReplaceableBlock);
    }
}

