/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.datagen;

import java.util.Set;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.regions_unexplored.data.noise.RuNoises;
import net.regions_unexplored.datagen.provider.RuAdvancementProvider;
import net.regions_unexplored.datagen.provider.RuBiomeTagProvider;
import net.regions_unexplored.datagen.provider.RuBlockModelProvider;
import net.regions_unexplored.datagen.provider.RuBlockTagProvider;
import net.regions_unexplored.datagen.provider.RuItemTagProvider;
import net.regions_unexplored.datagen.provider.RuLanguageProvider;
import net.regions_unexplored.datagen.provider.RuLootTableProvider;
import net.regions_unexplored.datagen.provider.RuRecipeProvider;
import net.regions_unexplored.entity.RuDamageTypes;
import net.regions_unexplored.registry.BiomeRegistry;
import net.regions_unexplored.registry.ConfiguredFeatureRegistry;
import net.regions_unexplored.registry.PlacedFeatureRegistry;

@Mod.EventBusSubscriber(modid="regions_unexplored", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGeneration {
    private static final RegistrySetBuilder BOOTSTRAPS = new RegistrySetBuilder().m_254916_(Registries.f_256952_, BiomeRegistry::bootstrap).m_254916_(Registries.f_268580_, RuDamageTypes::bootstrap).m_254916_(Registries.f_256865_, RuNoises::bootstrap).m_254916_(Registries.f_256911_, ConfiguredFeatureRegistry::bootstrap).m_254916_(Registries.f_256988_, PlacedFeatureRegistry::bootstrap);

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, event.getLookupProvider(), BOOTSTRAPS, Set.of("regions_unexplored")));
        generator.addProvider(event.includeServer(), (DataProvider)new RuBlockModelProvider(packOutput, "regions_unexplored", existingFileHelper));
        TagsProvider blockTagsProvider = (TagsProvider)generator.addProvider(event.includeServer(), (DataProvider)new RuBlockTagProvider(packOutput, event.getLookupProvider(), "regions_unexplored", existingFileHelper));
        TagsProvider itemTagsProvider = (TagsProvider)generator.addProvider(event.includeServer(), (DataProvider)new RuItemTagProvider(packOutput, event.getLookupProvider(), blockTagsProvider.m_274426_(), "regions_unexplored", existingFileHelper));
        TagsProvider biomeTagsProvider = (TagsProvider)generator.addProvider(event.includeServer(), (DataProvider)new RuBiomeTagProvider(packOutput, event.getLookupProvider(), "regions_unexplored", existingFileHelper));
        generator.addProvider(true, (DataProvider)new RuAdvancementProvider(packOutput, event.getLookupProvider(), existingFileHelper));
        generator.addProvider(true, (DataProvider)RuLootTableProvider.create(packOutput));
        generator.addProvider(true, (DataProvider)new RuRecipeProvider(packOutput));
        generator.addProvider(true, (DataProvider)new RuLanguageProvider(packOutput));
    }
}

