/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.biome.builder;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.regions_unexplored.data.worldgen.RuBiomeDefaultFeatures;
import net.regions_unexplored.data.worldgen.placement.RuMiscOverworldPlacements;
import net.regions_unexplored.data.worldgen.placement.RuTreePlacements;
import net.regions_unexplored.data.worldgen.placement.RuVegetationPlacements;

public class CaveBiomes {
    protected static final int NORMAL_WATER_COLOR = 4159204;
    protected static final int NORMAL_WATER_FOG_COLOR = 329011;
    private static final int OVERWORLD_FOG_COLOR = 12638463;

    protected static int calculateSkyColor(float color) {
        float $$1 = color / 3.0f;
        $$1 = Mth.m_14036_((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    private static MobSpawnSettings.Builder baseCaveSpawning(boolean addDrowned) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_176859_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_194725_((MobSpawnSettings.Builder)spawnBuilder, (int)95, (int)5, (int)100, (boolean)false);
        if (addDrowned) {
            spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20562_, 95, 4, 4));
        }
        return spawnBuilder;
    }

    private static MobSpawnSettings.Builder baseLushCaveSpawning() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.AXOLOTLS, new MobSpawnSettings.SpawnerData(EntityType.f_147039_, 10, 4, 6));
        spawnBuilder.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20489_, 25, 8, 8));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        return spawnBuilder;
    }

    private static BiomeGenerationSettings.Builder baseCaveGeneration(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        RuBiomeDefaultFeatures.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addDefaultSoftDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126714_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return biomeBuilder;
    }

    private static BiomeGenerationSettings.Builder baseLushCaveGeneration(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter, boolean addClay) {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        RuBiomeDefaultFeatures.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        if (addClay) {
            BiomeDefaultFeatures.m_176852_((BiomeGenerationSettings.Builder)biomeBuilder);
        }
        RuBiomeDefaultFeatures.addDefaultSoftDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        return biomeBuilder;
    }

    public static Biome ancientDelta(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(CaveBiomes.calculateSkyColor(0.7f)).m_48019_(12638463).m_48034_(-13369345).m_48037_(329011).m_48043_(-10118056).m_48045_(0xF8FF84).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_184222_));
        BiomeGenerationSettings.Builder biomeBuilder = CaveBiomes.baseLushCaveGeneration(featureGetter, carverGetter, true);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.MINERAL_POOL);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.BLADED_GRASS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.CORPSE_FLOWER);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.DUSKMELON);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.DUSKTRAP);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.DROPLEAF);
        MobSpawnSettings.Builder spawnBuilder = CaveBiomes.baseLushCaveSpawning();
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(1.125f).m_47611_(0.8f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome bioshroomCaves(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(CaveBiomes.calculateSkyColor(2.0f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(-11093361).m_48045_(-11093410).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_175833_, 0.01f)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_184222_));
        BiomeGenerationSettings.Builder biomeBuilder = CaveBiomes.baseLushCaveGeneration(featureGetter, carverGetter, false);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.GIANT_GREEN_BIOSHROOM);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.GIANT_BLUE_BIOSHROOM);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.CAVE_GRASS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.CAVE_TALL_GRASS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.BLUE_BIOSHROOM);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.GREEN_BIOSHROOM);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.PINK_BIOSHROOM);
        MobSpawnSettings.Builder spawnBuilder = CaveBiomes.baseLushCaveSpawning();
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(1.25f).m_47611_(0.9f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome prismachasm(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(CaveBiomes.calculateSkyColor(0.7f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(-16737793).m_48045_(-6625354).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123815_, 0.002f)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_184219_));
        BiomeGenerationSettings.Builder biomeBuilder = CaveBiomes.baseCaveGeneration(featureGetter, carverGetter);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.PRISMOSS_SPROUT);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.CAVE_HYSSOP);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.PRISMARITE_CLUSTERS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.HANGING_PRISMARITE_CLUSTER);
        MobSpawnSettings.Builder spawnBuilder = CaveBiomes.baseCaveSpawning(false);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.925f).m_47611_(0.9f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome redstoneCaves(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(CaveBiomes.calculateSkyColor(0.7f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(-6044317).m_48045_(-6044317).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_184219_));
        BiomeGenerationSettings.Builder biomeBuilder = CaveBiomes.baseCaveGeneration(featureGetter, carverGetter);
        RuBiomeDefaultFeatures.pointedRedstone(biomeBuilder);
        MobSpawnSettings.Builder spawnBuilder = CaveBiomes.baseCaveSpawning(false);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.8f).m_47611_(0.7f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome scorchingCaves(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(CaveBiomes.calculateSkyColor(0.7f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(-8949914).m_48045_(-8621472).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.1f)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_215729_));
        BiomeGenerationSettings.Builder biomeBuilder = CaveBiomes.baseCaveGeneration(featureGetter, carverGetter);
        biomeBuilder.m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, RuMiscOverworldPlacements.OVERWORLD_LAVA_DELTA);
        biomeBuilder.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, RuMiscOverworldPlacements.BASALT_BLOB);
        biomeBuilder.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, RuMiscOverworldPlacements.ASH_VENT);
        biomeBuilder.m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, RuMiscOverworldPlacements.LAVA_FALL);
        MobSpawnSettings.Builder spawnBuilder = CaveBiomes.baseCaveSpawning(false);
        return new Biome.BiomeBuilder().m_264558_(false).m_47609_(2.0f).m_47611_(0.0f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }
}

