/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.experimental.config;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.config.ConfigFlagManager;
import org.violetmoon.zeta.config.type.IConfigType;
import org.violetmoon.zeta.module.ZetaModule;

public class VariantsConfig
implements IConfigType {
    private static final VariantMap EMPTY_VARIANT_MAP = new VariantMap(new HashMap<String, Block>());
    @Config(description="The list of all variant types available for players to use. Values are treated as suffixes to block IDs for scanning.\nPrefix any variant type with ! to make it show up for Manual Variants but not be automatically scanned for. (e.g. '!polish')")
    private List<String> variantTypes = Arrays.asList("slab", "stairs", "wall", "fence", "fence_gate", "vertical_slab");
    @Config(description="By default, only a mod's namespace is scanned for variants for its items (e.g. if coolmod adds coolmod:fun_block, it'll search only for coolmod:fun_block_stairs).\n Mods in this list are also scanned for variants if none are found in itself (e.g. if quark is in the list and coolmod:fun_block_stairs doesn't exist, it'll try to look for quark:fun_block_stairs next)")
    private List<String> testedMods = Arrays.asList("quark", "everycomp", "v_slab_compat");
    @Config
    private boolean printVariantMapToLog = false;
    @Config(description="Format is 'alias=original' in each value (e.g. 'wall=fence' means that a failed search for, minecraft:cobblestone_fence will try cobblestone_wall next)")
    private List<String> aliases = Arrays.asList("carpet=slab", "pane=fence");
    @Config(description="Ends of block IDs to try and remove when looking for variants. (e.g. minecraft:oak_planks goes into minecraft:oak_stairs, so we have to include '_planks' in this list for it to find them or else it'll only look for minecraft:oak_planks_stairs)")
    private List<String> stripCandidates = Arrays.asList("_planks", "_wool", "_block", "s");
    @Config(description="Add manual variant overrides here, the format is 'type,block,output' (e.g. polish,minecraft:stone_bricks,minecraft:chiseled_stone_bricks). The type must be listed in Variant Types")
    private List<String> manualVariants = new ArrayList<String>();
    @Config(description=" A list of block IDs and mappings to be excluded from variant selection.\nTo exclude a block from being turned into other blocks, just include the block ID (e.g. minecraft:cobblestone).\nTo exclude a block from having other blocks turned into it, suffix it with = (e.g. =minecraft:cobblestone_stairs)\nTo exclude a specific block->variant combination, put = between the two (e.g. minecraft:cobblestone=minecraft:cobblestone_stairs)")
    private List<String> blacklist = Arrays.asList("minecraft:snow", "minecraft:bamboo", "minecraft:bamboo_block");
    private final Map<Block, VariantMap> blockVariants = new HashMap<Block, VariantMap>();
    private final Map<Block, Block> originals = new HashMap<Block, Block>();
    private final Multimap<String, String> aliasMap = HashMultimap.create();
    private final Multimap<Block, ManualVariant> manualVariantMap = HashMultimap.create();
    private final List<String> visibleVariants = new ArrayList<String>();
    private final List<String> sortedSuffixes = new ArrayList<String>();

    public void onReload(ZetaModule module, ConfigFlagManager flagManager) {
        String[] toks;
        this.blockVariants.clear();
        this.visibleVariants.clear();
        this.originals.clear();
        this.aliasMap.clear();
        this.manualVariantMap.clear();
        this.sortedSuffixes.clear();
        if (module != null && !module.isEnabled()) {
            return;
        }
        for (String s : this.variantTypes) {
            this.visibleVariants.add(s.replaceAll("!", ""));
        }
        this.sortedSuffixes.addAll(this.visibleVariants);
        this.sortedSuffixes.sort((s1, s2) -> {
            int ct1 = s1.replaceAll("[^_]", "").length();
            int ct2 = s2.replaceAll("[^_]", "").length();
            return ct2 - ct1;
        });
        for (String s : this.aliases) {
            toks = s.split("=");
            this.aliasMap.put((Object)toks[1], (Object)toks[0]);
        }
        for (String s : this.manualVariants) {
            toks = s.split(",");
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(toks[1]));
            Block out = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(toks[2]));
            this.manualVariantMap.put((Object)block, (Object)new ManualVariant(toks[0], out));
        }
        BuiltInRegistries.f_256975_.forEach(this::getVariants);
        if (this.printVariantMapToLog) {
            this.logVariantMap();
        }
    }

    @Nullable
    public String findVariantForBlock(Block variantBlock) {
        String name = BuiltInRegistries.f_256975_.m_7981_((Object)variantBlock).m_135815_();
        for (String suffix : this.sortedSuffixes) {
            if (name.endsWith("_" + suffix)) {
                return suffix;
            }
            if (!this.aliasMap.containsKey((Object)suffix)) continue;
            for (String alias : this.aliasMap.get((Object)suffix)) {
                if (!name.endsWith("_" + alias)) continue;
                return suffix;
            }
        }
        return null;
    }

    @Nullable
    public Block getBlockOfVariant(Block baseBlock, @NotNull String variant) {
        if (!this.sortedSuffixes.contains(variant)) {
            return null;
        }
        VariantMap map = this.getVariants(baseBlock);
        return map.variants.get(variant);
    }

    @Nullable
    public String getVariantOfBlock(Block baseBlock, Block possibleVariant) {
        VariantMap map = this.getVariants(baseBlock);
        if (map != null) {
            for (Map.Entry<String, Block> entry : map.variants.entrySet()) {
                if (!entry.getValue().equals(possibleVariant)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public boolean hasVariants(Block block) {
        return !this.getVariants(block).isEmpty();
    }

    public Collection<Block> getAllVariants(Block block) {
        Map<String, Block> map = this.getVariants((Block)block).variants;
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (String s : this.variantTypes) {
            if (s.startsWith("!")) {
                s = s.substring(1);
            }
            if (!map.containsKey(s)) continue;
            blocks.add(map.get(s));
        }
        return blocks;
    }

    public Block getOriginalBlock(Block block) {
        return this.originals.getOrDefault(block, block);
    }

    public boolean isOriginal(Block block) {
        return this.originals.containsValue(block);
    }

    public boolean isVariant(Block block) {
        return this.originals.containsKey(block);
    }

    private VariantMap getVariants(Block block) {
        if (this.blockVariants.containsKey(block)) {
            return this.blockVariants.get(block);
        }
        HashMap<String, Block> newVariants = new HashMap<String, Block>();
        if (!this.isBlacklisted(block, null)) {
            for (String s : this.sortedSuffixes) {
                Block suffixed;
                if (!this.variantTypes.contains(s) || (suffixed = this.getSuffixedBlock(block, s)) == null || this.isBlacklisted(null, suffixed) || this.isBlacklisted(block, suffixed)) continue;
                newVariants.put(s, suffixed);
                this.originals.put(suffixed, block);
            }
        }
        if (this.manualVariantMap.containsKey((Object)block)) {
            for (ManualVariant mv : this.manualVariantMap.get((Object)block)) {
                newVariants.put(mv.type, mv.out);
                this.originals.put(mv.out, block);
            }
        }
        if (newVariants.isEmpty()) {
            this.blockVariants.put(block, EMPTY_VARIANT_MAP);
        } else {
            this.blockVariants.put(block, new VariantMap(newVariants));
        }
        return this.getVariants(block);
    }

    private Block getSuffixedBlock(Block ogBlock, String suffix) {
        String name;
        ResourceLocation resloc = BuiltInRegistries.f_256975_.m_7981_((Object)ogBlock);
        String namespace = resloc.m_135827_();
        Block ret = this.getSuffixedBlock(namespace, name = resloc.m_135815_(), suffix, "%s:%s_%s");
        if (ret != null) {
            return ret;
        }
        for (String mod : this.testedMods) {
            if (!Quark.ZETA.isModLoaded(mod)) continue;
            ret = this.getSuffixedBlock(mod, name, suffix, "%s:%s_%s");
            if (ret != null) {
                return ret;
            }
            ret = this.getSuffixedBlock(mod, name, suffix, "%s:" + namespace + "/%s_%s");
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private Block getSuffixedBlock(String namespace, String name, String suffix, String format) {
        for (String strip : this.stripCandidates) {
            String stripped;
            Block strippedAttempt;
            if (!name.endsWith(strip) || (strippedAttempt = this.getSuffixedBlock(namespace, stripped = name.substring(0, name.length() - strip.length()), suffix, format)) == null) continue;
            return strippedAttempt;
        }
        String targetStr = String.format(Locale.ROOT, format, namespace, name, suffix);
        ResourceLocation target = new ResourceLocation(targetStr);
        Block ret = (Block)BuiltInRegistries.f_256975_.m_7745_(target);
        if (ret == Blocks.f_50016_) {
            if (this.aliasMap.containsKey((Object)suffix)) {
                for (String alias : this.aliasMap.get((Object)suffix)) {
                    Block aliasAttempt = this.getSuffixedBlock(namespace, name, alias, format);
                    if (aliasAttempt == null) continue;
                    return aliasAttempt;
                }
            }
            return null;
        }
        return ret;
    }

    private boolean isBlacklisted(Block block, Block result) {
        if (this.blacklist.isEmpty()) {
            return false;
        }
        Object search = "";
        if (block != null) {
            search = (String)search + BuiltInRegistries.f_256975_.m_7981_((Object)block).toString();
        }
        if (result != null) {
            search = (String)search + "=" + BuiltInRegistries.f_256975_.m_7981_((Object)result).toString();
        }
        return !((String)search).isEmpty() && this.blacklist.contains(search);
    }

    public boolean isKnownVariant(String variant) {
        return this.visibleVariants.contains(variant);
    }

    public List<String> getVisibleVariants() {
        return this.visibleVariants;
    }

    private void logVariantMap() {
        for (Map.Entry<Block, Block> entry : this.originals.entrySet()) {
            Quark.LOG.info("{} is variant of {}", (Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    private record ManualVariant(String type, Block out) {
    }

    private record VariantMap(Map<String, Block> variants) {
        private boolean isEmpty() {
            return this.variants.isEmpty();
        }
    }
}

