/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.wind;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.config.Cfg;
import tictim.paraglider.wind.WindChunk;
import tictim.paraglider.wind.WindNode;

public final class Wind {
    private static final int XZ_RAD_HALF = 4;
    private static final int GROUND_Y_MIN = -2;
    private static final int GROUND_Y_MAX = 4;
    private static final int PARAGLIDING_Y_MIN = -11;
    private static final int PARAGLIDING_Y_MAX = 1;
    private static final Map<LevelAccessor, Wind> windInstances = new Object2ObjectOpenHashMap();
    private final Long2ObjectMap<WindChunk> windChunks = new Long2ObjectOpenHashMap();
    private final LongSet dirtyWindChunks = new LongOpenHashSet();
    private final BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
    @Nullable
    private WindChunk windChunkCache;

    public static void registerLevel(@NotNull LevelAccessor level) {
        windInstances.computeIfAbsent(level, l -> new Wind());
    }

    public static void unregisterLevel(@NotNull LevelAccessor level) {
        windInstances.remove(level);
    }

    @Nullable
    public static Wind of(@NotNull LevelAccessor level) {
        return windInstances.get(level);
    }

    private Wind() {
    }

    @NotNull
    public @NotNull @Unmodifiable Collection<@NotNull WindChunk> windChunks() {
        return Collections.unmodifiableCollection(this.windChunks.values());
    }

    @NotNull
    public LongSet dirtyWindChunks() {
        return this.dirtyWindChunks;
    }

    @Nullable
    public WindChunk getChunk(@NotNull ChunkPos chunkPos) {
        return this.getChunk(chunkPos.f_45578_, chunkPos.f_45579_);
    }

    @Nullable
    public WindChunk getChunk(int chunkX, int chunkZ) {
        return this.getChunk(ChunkPos.m_45589_((int)chunkX, (int)chunkZ));
    }

    @Nullable
    public WindChunk getChunk(long chunkPos) {
        return (WindChunk)this.windChunks.get(chunkPos);
    }

    @NotNull
    public WindChunk getOrCreate(@NotNull ChunkPos chunkPos) {
        return this.getOrCreate(chunkPos.m_45588_());
    }

    @NotNull
    public WindChunk getOrCreate(int chunkX, int chunkZ) {
        return this.getOrCreate(ChunkPos.m_45589_((int)chunkX, (int)chunkZ));
    }

    @NotNull
    public WindChunk getOrCreate(long chunkPos) {
        return (WindChunk)this.windChunks.computeIfAbsent(chunkPos, cp -> new WindChunk(new ChunkPos(cp)));
    }

    @Nullable
    public WindChunk remove(int chunkX, int chunkZ) {
        return this.remove(ChunkPos.m_45589_((int)chunkX, (int)chunkZ));
    }

    @Nullable
    public WindChunk remove(@NotNull ChunkPos chunkPos) {
        return this.remove(chunkPos.m_45588_());
    }

    @Nullable
    public WindChunk remove(long chunkPos) {
        WindChunk removed = (WindChunk)this.windChunks.remove(chunkPos);
        if (removed != null) {
            removed.setRemoved();
        }
        return removed;
    }

    public void put(@NotNull WindChunk windChunk) {
        if (windChunk.isRemoved()) {
            throw new IllegalArgumentException("Cannot add back a removed wind chunk!");
        }
        this.windChunks.put(windChunk.chunkPos.m_45588_(), (Object)windChunk);
    }

    public void writeWind(int x, int y, int z, int height, long gameTime) {
        long chunkPos = ChunkPos.m_45589_((int)SectionPos.m_123171_((int)x), (int)SectionPos.m_123171_((int)z));
        if (this.windChunkCache == null || this.windChunkCache.isRemoved() || this.windChunkCache.chunkPos.m_45588_() != chunkPos) {
            this.windChunkCache = this.getOrCreate(chunkPos);
        }
        if (this.windChunkCache.add(x, y, z, height, gameTime)) {
            this.dirtyWindChunks().add(chunkPos);
        }
    }

    public void placeAround(@NotNull Player player) {
        int x = Mth.m_14107_((double)player.m_20185_());
        int y = Mth.m_14107_((double)player.m_20186_());
        int z = Mth.m_14107_((double)player.m_20189_());
        this.place(player.m_9236_(), x - 4, y + (player.m_20096_() ? -2 : -11), z - 4, x + 4, y + (player.m_20096_() ? 4 : 1), z + 4);
    }

    private void place(@NotNull Level level, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int x = minX; x <= maxX; ++x) {
            block1: for (int z = minZ; z <= maxZ; ++z) {
                if (!level.m_7726_().m_5563_(SectionPos.m_123171_((int)x), SectionPos.m_123171_((int)z))) continue;
                boolean hasFireY = false;
                int fireY = 0;
                int y = minY;
                while (true) {
                    block9: {
                        boolean isWindSource;
                        block8: {
                            this.mpos.m_122178_(x, y, z);
                            BlockState state = level.m_8055_((BlockPos)this.mpos);
                            isWindSource = Cfg.get().isWindSource(state);
                            if (!hasFireY) break block8;
                            int height = y - fireY;
                            if (height < 10 && !isWindSource && !state.m_280555_() && !Block.m_49863_((LevelReader)level, (BlockPos)this.mpos, (Direction)Direction.DOWN) && !Block.m_49863_((LevelReader)level, (BlockPos)this.mpos, (Direction)Direction.UP)) break block9;
                            if (height > 2) {
                                this.writeWind(x, fireY, z, height, level.m_46467_());
                            }
                            hasFireY = false;
                        }
                        if (y > maxY) continue block1;
                        if (isWindSource) {
                            fireY = y;
                            hasFireY = true;
                        }
                    }
                    ++y;
                }
            }
        }
    }

    public void checkPlacedWind(@NotNull Level level) {
        for (WindChunk windChunk : this.windChunks()) {
            Collection<WindNode> allRootNodes = windChunk.getAllRootNodes();
            for (WindNode node : allRootNodes.toArray(new WindNode[0])) {
                WindNode updated = this.validate(windChunk, node, level);
                if (updated == node) continue;
                if (updated == null) {
                    windChunk.removeAllNodesInXZ(node.x, node.z);
                    continue;
                }
                windChunk.putNode(updated);
            }
        }
    }

    @Nullable
    private WindNode validate(@NotNull WindChunk windChunk, @NotNull WindNode node, @NotNull Level level) {
        long gameTime = level.m_46467_();
        if (node.updatedTime != gameTime) {
            if (node.isExpired(gameTime) || !Cfg.get().isWindSource(level.m_8055_((BlockPos)this.mpos.m_122178_(node.x, node.y, node.z)))) {
                this.dirtyWindChunks().add(windChunk.chunkPos.m_45588_());
                return node.next != null ? this.validate(windChunk, node.next, level) : null;
            }
            node.updatedTime = gameTime;
        }
        if (node.next != null) {
            node.next = this.validate(windChunk, node.next, level);
        }
        return node;
    }

    public static boolean isInside(@NotNull Level level, @NotNull AABB boundingBox) {
        return Wind.isInside(level, Mth.m_14107_((double)boundingBox.f_82288_), Mth.m_14107_((double)boundingBox.f_82289_), Mth.m_14107_((double)boundingBox.f_82290_), Mth.m_14165_((double)boundingBox.f_82291_), Mth.m_14165_((double)boundingBox.f_82292_), Mth.m_14165_((double)boundingBox.f_82293_));
    }

    public static boolean isInside(@NotNull Level level, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        Wind wind = Wind.of((LevelAccessor)level);
        if (wind == null) {
            return false;
        }
        int chunkXStart = minX >> 4;
        int chunkXEnd = maxX >> 4;
        int chunkZStart = minZ >> 4;
        int chunkZEnd = maxZ >> 4;
        for (int x = chunkXStart; x <= chunkXEnd; ++x) {
            for (int z = chunkZStart; z <= chunkZEnd; ++z) {
                WindChunk windChunk = wind.getChunk(x, z);
                if (windChunk == null || !windChunk.isInsideWind(minX, minY, minZ, maxX, maxY, maxZ)) continue;
                return true;
            }
        }
        return false;
    }
}

