/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.stamina.OtherStamina;
import com.alrex.parcool.common.network.SyncStaminaToClientMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncStaminaMessage {
    private int stamina = 0;
    private int max = 0;
    private boolean exhausted = false;
    private boolean imposingPenalty = false;
    private int consumeOnServer = 0;
    private int staminaType = -1;
    private UUID playerID = null;

    public void encode(FriendlyByteBuf packet) {
        packet.writeInt(this.stamina);
        packet.writeInt(this.max);
        packet.writeBoolean(this.exhausted);
        packet.writeBoolean(this.imposingPenalty);
        packet.writeInt(this.staminaType);
        packet.writeInt(this.consumeOnServer);
        packet.writeLong(this.playerID.getMostSignificantBits());
        packet.writeLong(this.playerID.getLeastSignificantBits());
    }

    public static SyncStaminaMessage decode(FriendlyByteBuf packet) {
        SyncStaminaMessage message = new SyncStaminaMessage();
        message.stamina = packet.readInt();
        message.max = packet.readInt();
        message.exhausted = packet.readBoolean();
        message.imposingPenalty = packet.readBoolean();
        message.staminaType = packet.readInt();
        message.consumeOnServer = packet.readInt();
        message.playerID = new UUID(packet.readLong(), packet.readLong());
        return message;
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public void handleServer(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            ParCool.CHANNEL_INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)this);
            if (player == null) {
                return;
            }
            IStamina stamina = IStamina.get((Player)player);
            if (!(stamina instanceof OtherStamina)) {
                return;
            }
            OtherStamina otherStamina = (OtherStamina)stamina;
            otherStamina.setMax(this.max);
            otherStamina.set(this.stamina);
            otherStamina.setImposingPenalty(this.imposingPenalty);
            otherStamina.setExhaustion(this.exhausted);
            if (this.staminaType != -1 && this.consumeOnServer > 0) {
                IStamina.Type.values()[this.staminaType].handleConsumeOnServer(player, this.consumeOnServer);
            }
            SyncStaminaToClientMessage.requestSync(player.m_20148_(), otherStamina);
        });
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            IStamina stamina;
            ServerPlayer player;
            boolean isInLogicalServer;
            ServerPlayer serverPlayer = null;
            boolean bl = isInLogicalServer = ((NetworkEvent.Context)contextSupplier.get()).getDirection().getReceptionSide() == LogicalSide.SERVER;
            if (isInLogicalServer) {
                serverPlayer = ((NetworkEvent.Context)contextSupplier.get()).getSender();
                player = serverPlayer;
                if (player == null) {
                    return;
                }
            } else {
                ClientLevel world = Minecraft.m_91087_().f_91073_;
                if (world == null) {
                    return;
                }
                player = world.m_46003_(this.playerID);
                if (player == null || player.m_7578_()) {
                    return;
                }
            }
            if (!((stamina = IStamina.get((Player)player)) instanceof OtherStamina)) {
                return;
            }
            OtherStamina otherStamina = (OtherStamina)stamina;
            otherStamina.setMax(this.max);
            otherStamina.set(this.stamina);
            otherStamina.setImposingPenalty(this.imposingPenalty);
            otherStamina.setExhaustion(this.exhausted);
            if (serverPlayer != null && this.staminaType != -1 && this.consumeOnServer > 0) {
                IStamina.Type.values()[this.staminaType].handleConsumeOnServer(serverPlayer, this.consumeOnServer);
            }
            if (isInLogicalServer) {
                SyncStaminaToClientMessage.requestSync(player.m_20148_(), otherStamina);
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sync(Player player) {
        IStamina stamina = IStamina.get(player);
        if (stamina == null || !player.m_7578_()) {
            return;
        }
        SyncStaminaMessage message = new SyncStaminaMessage();
        message.stamina = stamina.get();
        message.max = stamina.getActualMaxStamina();
        message.exhausted = stamina.isExhausted();
        message.imposingPenalty = stamina.isImposingExhaustionPenalty();
        message.consumeOnServer = stamina.getRequestedValueConsumedOnServer();
        IStamina.Type type = IStamina.Type.getFromInstance(stamina);
        message.staminaType = type != null ? type.ordinal() : -1;
        message.playerID = player.m_20148_();
        ParCool.CHANNEL_INSTANCE.sendToServer((Object)message);
    }
}

