/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.capability.stamina;

import com.alrex.parcool.api.Attributes;
import com.alrex.parcool.api.Effects;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;

public class ParCoolStamina
implements IStamina {
    private final Player player;
    private int stamina = 0;
    private int staminaOld = 0;
    private boolean exhausted = false;
    private int recoverCoolTime = 0;

    public ParCoolStamina(Player player) {
        this.player = player;
        if (player != null && player.m_7578_()) {
            this.set(Integer.MAX_VALUE);
        }
    }

    @Override
    public int getActualMaxStamina() {
        Parkourability parkourability = Parkourability.get(this.player);
        if (parkourability == null) {
            return 1;
        }
        AttributeInstance attr = this.player.m_21051_((Attribute)Attributes.MAX_STAMINA.get());
        if (attr == null) {
            return 1;
        }
        return Math.min((int)attr.m_22135_(), parkourability.getActionInfo().getMaxStaminaLimit());
    }

    @Override
    public int get() {
        return this.stamina;
    }

    @Override
    public int getOldValue() {
        return this.staminaOld;
    }

    @Override
    public void consume(int value) {
        if (this.player == null) {
            return;
        }
        Parkourability parkourability = Parkourability.get(this.player);
        if (parkourability == null) {
            return;
        }
        if (this.exhausted || parkourability.getActionInfo().isStaminaInfinite(this.player.m_5833_() || this.player.m_7500_()) || this.player.m_21023_((MobEffect)Effects.INEXHAUSTIBLE.get())) {
            return;
        }
        this.recoverCoolTime = 30;
        this.set(this.stamina - value);
        if (this.stamina == 0) {
            this.exhausted = true;
        }
    }

    @Override
    public void recover(int value) {
        this.set(this.stamina + value);
        if (this.stamina == this.getActualMaxStamina()) {
            this.exhausted = false;
        }
    }

    @Override
    public boolean isExhausted() {
        return this.exhausted;
    }

    @Override
    public void setExhaustion(boolean value) {
        this.exhausted = value;
    }

    @Override
    public void tick() {
        if (this.recoverCoolTime > 0) {
            --this.recoverCoolTime;
        }
        if (this.recoverCoolTime <= 0) {
            if (this.player == null) {
                return;
            }
            Parkourability parkourability = Parkourability.get(this.player);
            if (parkourability == null) {
                return;
            }
            AttributeInstance attr = this.player.m_21051_((Attribute)Attributes.STAMINA_RECOVERY.get());
            if (attr == null) {
                return;
            }
            if (this.player.m_20096_()) {
                this.recover(Math.min((int)attr.m_22135_(), parkourability.getActionInfo().getStaminaRecoveryLimit()));
            } else {
                this.recover(Math.min((int)attr.m_22135_(), parkourability.getActionInfo().getStaminaRecoveryLimit()) / 5);
            }
        }
    }

    @Override
    public void updateOldValue() {
        this.staminaOld = this.stamina;
    }

    @Override
    public void set(int value) {
        this.stamina = Math.min(value, this.getActualMaxStamina());
        if (this.stamina <= 0) {
            this.stamina = 0;
        }
    }
}

