/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.client.RenderBehaviorEnforcer;
import com.alrex.parcool.client.animation.impl.HideInBlockAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.BehaviorEnforcer;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.Crawl;
import com.alrex.parcool.common.action.impl.Dive;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.BufferUtil;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HideInBlock
extends Action {
    private static final BehaviorEnforcer.ID ID_SHOW_NAME = BehaviorEnforcer.newID();
    private static final BehaviorEnforcer.ID ID_SNEAK = BehaviorEnforcer.newID();
    @Nullable
    Vec3 hidingPoint = null;
    @Nullable
    Tuple<BlockPos, BlockPos> hidingArea = null;
    @Nullable
    Vec3 enterPoint = null;
    @Nullable
    Vec3 lookDirection = null;
    boolean hidingBlockChanged = false;
    boolean keyPressed;
    boolean startedFromDiving;

    @Nullable
    public Vec3 getLookDirection() {
        return this.lookDirection;
    }

    public boolean isStandbyInAir(Parkourability parkourability) {
        if (!this.keyPressed) {
            return false;
        }
        Dive dive = parkourability.get(Dive.class);
        return (dive.isDoing() || dive.getNotDoingTick() < 2) && parkourability.getAdditionalProperties().getLandingTick() <= 1;
    }

    @Override
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        HitResult result;
        if (player.m_20142_() || player.f_19794_ || !player.m_20096_() || player.m_20069_() || player.m_20159_() || player.m_6067_() || this.getNotDoingTick() < 6 || player.f_20916_ > 0 || parkourability.get(Crawl.class).isDoing()) {
            return false;
        }
        BlockPos hideBaseBlockPos = null;
        boolean startFromDiving = false;
        if (this.isStandbyInAir(parkourability)) {
            hideBaseBlockPos = player.m_20183_().m_7495_();
            startFromDiving = true;
        } else if (KeyBindings.getKeyHideInBlock().m_90857_() && (!ParCoolConfig.Client.Booleans.HideInBlockSneakNeeded.get().booleanValue() || player.m_20089_() == Pose.CROUCHING) && (result = Minecraft.m_91087_().f_91077_) instanceof BlockHitResult && parkourability.isDoingNothing()) {
            hideBaseBlockPos = ((BlockHitResult)result).m_82425_();
        }
        if (hideBaseBlockPos != null) {
            Vec3 direction;
            boolean stand;
            Tuple hideArea = WorldUtil.getHideAbleSpace((Entity)player, hideBaseBlockPos);
            if (hideArea == null) {
                return false;
            }
            Vec3 hidePoint = new Vec3(0.5 + (double)(((BlockPos)hideArea.m_14418_()).m_123341_() + ((BlockPos)hideArea.m_14419_()).m_123341_()) / 2.0, (double)Math.min(((BlockPos)hideArea.m_14418_()).m_123342_(), ((BlockPos)hideArea.m_14419_()).m_123342_()), 0.5 + (double)(((BlockPos)hideArea.m_14418_()).m_123343_() + ((BlockPos)hideArea.m_14419_()).m_123343_()) / 2.0);
            if (!player.m_20182_().m_82509_((Position)hidePoint, 1.8)) {
                return false;
            }
            int minX = Math.min(((BlockPos)hideArea.m_14418_()).m_123341_(), ((BlockPos)hideArea.m_14419_()).m_123341_());
            int maxX = Math.max(((BlockPos)hideArea.m_14418_()).m_123341_(), ((BlockPos)hideArea.m_14419_()).m_123341_());
            int minY = Math.min(((BlockPos)hideArea.m_14418_()).m_123342_(), ((BlockPos)hideArea.m_14419_()).m_123342_());
            int maxY = Math.max(((BlockPos)hideArea.m_14418_()).m_123342_(), ((BlockPos)hideArea.m_14419_()).m_123342_());
            int minZ = Math.min(((BlockPos)hideArea.m_14418_()).m_123343_(), ((BlockPos)hideArea.m_14419_()).m_123343_());
            int maxZ = Math.max(((BlockPos)hideArea.m_14418_()).m_123343_(), ((BlockPos)hideArea.m_14419_()).m_123343_());
            hideArea = new Tuple((Object)new BlockPos(minX, minY, minZ), (Object)new BlockPos(maxX, maxY, maxZ));
            boolean bl = stand = player.m_20206_() < (float)(((BlockPos)hideArea.m_14419_()).m_123342_() - ((BlockPos)hideArea.m_14418_()).m_123342_() + 1);
            if (stand && startFromDiving) {
                return false;
            }
            if (stand) {
                Vec3 lookAngle = player.m_20154_();
                direction = Math.abs(lookAngle.m_7096_()) > Math.abs(lookAngle.m_7094_()) ? new Vec3(lookAngle.m_7096_() > 0.0 ? 1.0 : -1.0, 0.0, 0.0) : new Vec3(0.0, 0.0, lookAngle.m_7094_() > 0.0 ? 1.0 : -1.0);
            } else {
                boolean zLonger;
                boolean bl2 = zLonger = Math.abs(((BlockPos)hideArea.m_14418_()).m_123343_() - ((BlockPos)hideArea.m_14419_()).m_123343_()) > Math.abs(((BlockPos)hideArea.m_14418_()).m_123341_() - ((BlockPos)hideArea.m_14419_()).m_123341_());
                direction = zLonger ? new Vec3(0.0, 0.0, player.m_20154_().m_7094_() > 0.0 ? 1.0 : -1.0) : new Vec3(player.m_20154_().m_7096_() > 0.0 ? 1.0 : -1.0, 0.0, 0.0);
            }
            BufferUtil.wrap(startInfo).putBoolean(stand).putBoolean(startFromDiving).putBlockPos((BlockPos)hideArea.m_14418_()).putBlockPos((BlockPos)hideArea.m_14419_()).putVec3(hidePoint).putVec3(player.m_20182_()).putVec3(direction);
            return true;
        }
        return false;
    }

    @Override
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        if (this.hidingBlockChanged) {
            this.hidingBlockChanged = false;
            return false;
        }
        return (player.f_20916_ <= 0 || this.startedFromDiving && this.getDoingTick() < 10) && player.m_20089_() == Pose.STANDING && (this.getDoingTick() < 6 || KeyBindings.getKeyHideInBlock().m_90857_() || KeyBindings.getKeySneak().m_90857_());
    }

    @Override
    public void onStart(Player player, Parkourability parkourability, ByteBuffer startData) {
        boolean _stand = BufferUtil.getBoolean(startData);
        this.startedFromDiving = BufferUtil.getBoolean(startData);
        this.hidingArea = new Tuple((Object)BufferUtil.getBlockPos(startData), (Object)BufferUtil.getBlockPos(startData));
        this.hidingPoint = BufferUtil.getVec3(startData);
        this.enterPoint = BufferUtil.getVec3(startData);
        this.lookDirection = BufferUtil.getVec3(startData);
        if (this.startedFromDiving) {
            parkourability.getBehaviorEnforcer().setMarkerEnforcePosition(this::isDoing, () -> this.hidingPoint);
        } else {
            parkourability.getBehaviorEnforcer().setMarkerEnforcePosition(this::isDoing, () -> {
                if (this.getDoingTick() == 0) {
                    return this.hidingPoint.m_82546_(this.enterPoint).m_82490_(0.75).m_82549_(this.enterPoint);
                }
                return this.hidingPoint;
            });
        }
        parkourability.getBehaviorEnforcer().addMarkerCancellingSneak(ID_SNEAK, this::isDoing);
        player.m_20124_(Pose.STANDING);
        player.f_19794_ = true;
        player.m_5496_(player.m_9236_().m_8055_(new BlockPos(Mth.m_14107_((double)this.hidingPoint.m_7096_()), Mth.m_14107_((double)(this.hidingPoint.m_7098_() + 0.2)), Mth.m_14107_((double)this.hidingPoint.m_7094_()))).m_60827_().m_56775_(), 1.0f, 1.0f);
    }

    @Override
    public void onStartInLocalClient(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        boolean stand = BufferUtil.getBoolean(startData);
        RenderBehaviorEnforcer.serMarkerEnforceCameraType(this::isDoing, () -> CameraType.THIRD_PERSON_BACK);
        parkourability.getBehaviorEnforcer().addMarkerCancellingShowName(ID_SHOW_NAME, this::isDoing);
        this.spawnOnHideParticles(player);
        Animation animation = Animation.get(player);
        if (animation == null) {
            return;
        }
        animation.setAnimator(new HideInBlockAnimator(stand, this.startedFromDiving));
    }

    @Override
    public void onStartInOtherClient(Player player, Parkourability parkourability, ByteBuffer startData) {
        boolean stand = BufferUtil.getBoolean(startData);
        Animation animation = Animation.get(player);
        parkourability.getBehaviorEnforcer().addMarkerCancellingShowName(ID_SHOW_NAME, this::isDoing);
        this.spawnOnHideParticles(player);
        if (animation == null) {
            return;
        }
        animation.setAnimator(new HideInBlockAnimator(stand, this.startedFromDiving));
    }

    @Override
    public void onWorkingTickInServer(Player player, Parkourability parkourability, IStamina stamina) {
        if (this.hidingPoint == null) {
            return;
        }
        player.m_6034_(this.hidingPoint.m_7096_(), this.hidingPoint.m_7098_(), this.hidingPoint.m_7094_());
    }

    @Override
    public void onWorkingTick(Player player, Parkourability parkourability, IStamina stamina) {
        player.m_20256_(Vec3.f_82478_);
        player.f_19794_ = true;
        player.m_6858_(false);
        player.m_20124_(Pose.STANDING);
    }

    @Override
    public void onStopInLocalClient(Player player) {
        Vec3 hidePos = this.hidingPoint;
        Vec3 entPos = this.enterPoint;
        Parkourability parkourability = Parkourability.get(player);
        if (parkourability == null) {
            return;
        }
        parkourability.getBehaviorEnforcer().setMarkerEnforcePosition(() -> this.getNotDoingTick() <= 1, () -> {
            if (this.getNotDoingTick() == 0) {
                return entPos.m_82546_(hidePos).m_82490_(0.65).m_82549_(hidePos);
            }
            return entPos;
        });
        this.spawnOnHideParticles(player);
        player.m_5496_(player.m_9236_().m_8055_(new BlockPos(Mth.m_14107_((double)this.hidingPoint.m_7096_()), Mth.m_14107_((double)(this.hidingPoint.m_7098_() + 0.2)), Mth.m_14107_((double)this.hidingPoint.m_7094_()))).m_60827_().m_56775_(), 1.0f, 1.0f);
    }

    @Override
    public void onStopInOtherClient(Player player) {
        this.spawnOnHideParticles(player);
        player.m_5496_(player.m_9236_().m_8055_(new BlockPos(Mth.m_14107_((double)this.hidingPoint.m_7096_()), Mth.m_14107_((double)(this.hidingPoint.m_7098_() + 0.2)), Mth.m_14107_((double)this.hidingPoint.m_7094_()))).m_60827_().m_56775_(), 1.0f, 1.0f);
    }

    @Override
    public void onStop(Player player) {
        this.hidingPoint = null;
        this.enterPoint = null;
        this.hidingArea = null;
        this.lookDirection = null;
        player.f_19794_ = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnOnHideParticles(Player player) {
        if (this.hidingArea == null) {
            return;
        }
        Level world = player.m_9236_();
        int minX = ((BlockPos)this.hidingArea.m_14418_()).m_123341_();
        int minY = ((BlockPos)this.hidingArea.m_14418_()).m_123342_();
        int minZ = ((BlockPos)this.hidingArea.m_14418_()).m_123343_();
        int maxX = ((BlockPos)this.hidingArea.m_14419_()).m_123341_();
        int maxY = ((BlockPos)this.hidingArea.m_14419_()).m_123342_();
        int maxZ = ((BlockPos)this.hidingArea.m_14419_()).m_123343_();
        for (int y = minY; y <= maxY; ++y) {
            for (int z = minZ; z <= maxZ; ++z) {
                BlockPos pos;
                for (int x = minX; x <= maxX && world.m_46749_(pos = new BlockPos(x, y, z)); ++x) {
                    Minecraft.m_91087_().f_91061_.m_107355_(pos, world.m_8055_(pos));
                }
            }
        }
    }

    @Override
    public void onClientTick(Player player, Parkourability parkourability, IStamina stamina) {
        this.keyPressed = KeyBindings.getKeyHideInBlock().m_90857_();
    }

    @Override
    public void saveSynchronizedState(ByteBuffer buffer) {
        BufferUtil.wrap(buffer).putBoolean(this.keyPressed);
    }

    @Override
    public void restoreSynchronizedState(ByteBuffer buffer) {
        this.keyPressed = BufferUtil.getBoolean(buffer);
    }

    private boolean isHidingBlock(BlockPos pos) {
        if (this.hidingArea == null) {
            return false;
        }
        BlockPos posA = (BlockPos)this.hidingArea.m_14418_();
        BlockPos posB = (BlockPos)this.hidingArea.m_14419_();
        return posA.m_123341_() <= pos.m_123341_() && pos.m_123341_() <= posB.m_123341_() && posA.m_123342_() <= pos.m_123342_() && pos.m_123342_() <= posB.m_123342_() && posA.m_123343_() <= pos.m_123343_() && pos.m_123343_() <= posB.m_123343_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void notifyBlockChanged(BlockPos pos) {
        if (this.isHidingBlock(pos)) {
            this.hidingBlockChanged = true;
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.None;
    }

    @Nullable
    public Tuple<BlockPos, BlockPos> getHidingArea() {
        return this.hidingArea;
    }
}

