/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.api.SoundEvents;
import com.alrex.parcool.client.animation.impl.CatLeapAnimator;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.ChargeJump;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.action.impl.HideInBlock;
import com.alrex.parcool.common.action.impl.Roll;
import com.alrex.parcool.common.action.impl.Tap;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import java.nio.ByteBuffer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CatLeap
extends Action {
    private int coolTimeTick = 0;
    private boolean ready = false;
    private int readyTick = 0;
    private static final int MAX_COOL_TIME_TICK = 30;

    @Override
    public void onTick(Player player, Parkourability parkourability, IStamina stamina) {
        if (this.coolTimeTick > 0) {
            --this.coolTimeTick;
        }
    }

    @Override
    public void onClientTick(Player player, Parkourability parkourability, IStamina stamina) {
        if (player.m_7578_()) {
            if (KeyRecorder.keySneak.isPressed() && parkourability.get(FastRun.class).getNotDashTick(parkourability.getAdditionalProperties()) < 10) {
                this.ready = true;
            }
            if (this.ready) {
                ++this.readyTick;
            }
            if (this.readyTick > 10) {
                this.ready = false;
                this.readyTick = 0;
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        Vec3 movement = player.m_20184_();
        if (movement.m_82556_() < 0.001) {
            return false;
        }
        movement = movement.m_82542_(1.0, 0.0, 1.0).m_82541_();
        startInfo.putDouble(movement.m_7096_()).putDouble(movement.m_7094_());
        return player.m_20096_() && !player.m_20069_() && !stamina.isExhausted() && this.coolTimeTick <= 0 && this.readyTick > 0 && parkourability.get(ChargeJump.class).getChargingTick() < 9 && !parkourability.get(HideInBlock.class).isDoing() && !parkourability.get(Roll.class).isDoing() && !parkourability.get(Tap.class).isDoing() && KeyRecorder.keySneak.isReleased();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        return (this.getDoingTick() <= 1 || !player.m_20096_()) && !player.m_21255_() && !player.m_20072_() && !player.m_20077_();
    }

    @Override
    public void onStartInLocalClient(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        Vec3 jumpDirection = new Vec3(startData.getDouble(), 0.0, startData.getDouble());
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.m_5496_((SoundEvent)SoundEvents.CATLEAP.get(), 1.0f, 1.0f);
        }
        this.coolTimeTick = 30;
        this.spawnJumpEffect(player, jumpDirection);
        player.m_6135_();
        Vec3 motionVec = player.m_20184_();
        player.m_20334_(jumpDirection.m_7096_(), motionVec.m_7098_() * 1.16667, jumpDirection.m_7094_());
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new CatLeapAnimator());
        }
    }

    @Override
    public void onStartInOtherClient(Player player, Parkourability parkourability, ByteBuffer startData) {
        Vec3 jumpDirection = new Vec3(startData.getDouble(), 0.0, startData.getDouble());
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.m_5496_((SoundEvent)SoundEvents.CATLEAP.get(), 1.0f, 1.0f);
        }
        this.spawnJumpEffect(player, jumpDirection);
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new CatLeapAnimator());
        }
    }

    @Override
    public boolean wantsToShowStatusBar(LocalPlayer player, Parkourability parkourability) {
        return this.coolTimeTick > 0;
    }

    @Override
    public float getStatusValue(LocalPlayer player, Parkourability parkourability) {
        return (float)this.coolTimeTick / 30.0f;
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnStart;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnJumpEffect(Player player, Vec3 jumpDirection) {
        Vec3 pos;
        Vec3 blockPosVec;
        BlockPos blockpos;
        if (!ParCoolConfig.Client.Booleans.EnableActionParticles.get().booleanValue()) {
            return;
        }
        Level level = player.m_9236_();
        if (!level.m_46749_(blockpos = new BlockPos(Mth.m_14107_((double)(blockPosVec = (pos = player.m_20182_()).m_82520_(0.0, -0.2, 0.0)).m_7096_()), Mth.m_14107_((double)blockPosVec.m_7098_()), Mth.m_14107_((double)blockPosVec.m_7094_())))) {
            return;
        }
        float width = player.m_20205_();
        BlockState blockstate = level.m_8055_(blockpos);
        if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
            for (int i = 0; i < 20; ++i) {
                Vec3 particlePos = new Vec3(pos.m_7096_() + (jumpDirection.m_7096_() * -0.5 + player.m_217043_().m_188500_() - 0.5) * (double)width, pos.m_7098_() + 0.1, pos.m_7094_() + (jumpDirection.m_7094_() * -0.5 + player.m_217043_().m_188500_() - 0.5) * (double)width);
                Vec3 particleSpeed = particlePos.m_82546_(pos).m_82541_().m_82490_(2.5 + 8.0 * player.m_217043_().m_188500_()).m_82520_(0.0, 1.5, 0.0);
                level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(blockpos), particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), particleSpeed.m_7096_(), particleSpeed.m_7098_(), particleSpeed.m_7094_());
            }
        }
    }
}

