/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.ingredient;

import com.google.gson.JsonObject;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;

public class SizedIngredient
implements Predicate<ItemStack> {
    public static final SizedIngredient EMPTY = SizedIngredient.of(Ingredient.f_43901_, 0);
    public static final RecordLoadable<SizedIngredient> LOADABLE = RecordLoadable.create(IngredientLoadable.DISALLOW_EMPTY.tryDirectField("ingredient", SizedIngredient::getIngredient, "amount_needed"), IntLoadable.FROM_ONE.defaultField("amount_needed", 1, SizedIngredient::getAmountNeeded), SizedIngredient::new);
    private final Ingredient ingredient;
    private final int amountNeeded;
    private WeakReference<ItemStack[]> lastIngredientMatch;
    private List<ItemStack> matchingStacks;

    public static SizedIngredient of(Ingredient ingredient) {
        return SizedIngredient.of(ingredient, 1);
    }

    public static SizedIngredient fromItems(int amountNeeded, ItemLike ... items) {
        return SizedIngredient.of(Ingredient.m_43929_((ItemLike[])items), amountNeeded);
    }

    public static SizedIngredient fromItems(ItemLike ... items) {
        return SizedIngredient.fromItems(1, items);
    }

    public static SizedIngredient fromTag(TagKey<Item> tag, int amountNeeded) {
        return SizedIngredient.of(Ingredient.m_204132_(tag), amountNeeded);
    }

    public static SizedIngredient fromTag(TagKey<Item> tag) {
        return SizedIngredient.fromTag(tag, 1);
    }

    @Override
    public boolean test(ItemStack stack) {
        return stack.m_41613_() >= this.amountNeeded && this.ingredient.test(stack);
    }

    public boolean isEmpty() {
        return this.ingredient.m_43947_();
    }

    public List<ItemStack> getMatchingStacks() {
        ItemStack[] ingredientMatch = this.ingredient.m_43908_();
        if (this.matchingStacks == null || this.lastIngredientMatch.get() != ingredientMatch) {
            this.matchingStacks = Arrays.stream(ingredientMatch).map(stack -> {
                if (stack.m_41613_() != this.amountNeeded) {
                    stack = stack.m_41777_();
                    stack.m_41764_(this.amountNeeded);
                }
                return stack;
            }).collect(Collectors.toList());
            this.lastIngredientMatch = new WeakReference<ItemStack[]>(ingredientMatch);
        }
        return this.matchingStacks;
    }

    @Deprecated(forRemoval=true)
    public void write(FriendlyByteBuf buffer) {
        LOADABLE.encode(buffer, this);
    }

    @Deprecated(forRemoval=true)
    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        LOADABLE.serialize(this, json);
        return json;
    }

    @Deprecated(forRemoval=true)
    public static SizedIngredient read(FriendlyByteBuf buffer) {
        return (SizedIngredient)LOADABLE.decode(buffer);
    }

    @Deprecated(forRemoval=true)
    public static SizedIngredient deserialize(JsonObject json) {
        return LOADABLE.deserialize(json);
    }

    private SizedIngredient(Ingredient ingredient, int amountNeeded) {
        this.ingredient = ingredient;
        this.amountNeeded = amountNeeded;
    }

    public static SizedIngredient of(Ingredient ingredient, int amountNeeded) {
        return new SizedIngredient(ingredient, amountNeeded);
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getAmountNeeded() {
        return this.amountNeeded;
    }
}

