/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.loot;

import com.google.gson.JsonDeserializer;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.loot.AddEntryLootModifier;
import slimeknights.mantle.loot.ReplaceItemLootModifier;
import slimeknights.mantle.loot.condition.BlockTagLootCondition;
import slimeknights.mantle.loot.condition.ContainsItemModifierLootCondition;
import slimeknights.mantle.loot.condition.EmptyModifierLootCondition;
import slimeknights.mantle.loot.condition.ILootModifierCondition;
import slimeknights.mantle.loot.condition.InvertedModifierLootCondition;
import slimeknights.mantle.loot.entry.TagPreferenceLootEntry;
import slimeknights.mantle.loot.function.RetexturedLootFunction;
import slimeknights.mantle.loot.function.SetFluidLootFunction;
import slimeknights.mantle.recipe.condition.TagEmptyCondition;
import slimeknights.mantle.recipe.condition.TagFilledCondition;
import slimeknights.mantle.registration.adapter.RegistryAdapter;

public class MantleLoot {
    public static LootItemConditionType TAG_EMPTY;
    public static LootItemConditionType TAG_FILLED;
    public static LootItemConditionType BLOCK_TAG_CONDITION;
    public static LootItemFunctionType RETEXTURED_FUNCTION;
    public static LootItemFunctionType SET_FLUID_FUNCTION;
    public static LootPoolEntryType TAG_PREFERENCE;

    public static void registerGlobalLootModifiers(RegisterEvent event) {
        ResourceKey key = event.getRegistryKey();
        if (key == ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS) {
            RegistryAdapter<String> adapter = new RegistryAdapter<String>(Objects.requireNonNull(event.getForgeRegistry()));
            adapter.register(AddEntryLootModifier.CODEC, "add_entry");
            adapter.register(ReplaceItemLootModifier.CODEC, "replace_item");
            ILootModifierCondition.MODIFIER_CONDITIONS.registerDeserializer(InvertedModifierLootCondition.ID, (JsonDeserializer<ILootModifierCondition>)((JsonDeserializer)InvertedModifierLootCondition::deserialize));
            ILootModifierCondition.MODIFIER_CONDITIONS.registerDeserializer(EmptyModifierLootCondition.ID, EmptyModifierLootCondition.INSTANCE);
            ILootModifierCondition.MODIFIER_CONDITIONS.registerDeserializer(ContainsItemModifierLootCondition.ID, (JsonDeserializer<ILootModifierCondition>)((JsonDeserializer)ContainsItemModifierLootCondition::deserialize));
        } else if (key == Registries.f_257015_) {
            RETEXTURED_FUNCTION = MantleLoot.registerFunction("fill_retextured_block", (Serializer<? extends LootItemFunction>)RetexturedLootFunction.SERIALIZER);
            SET_FLUID_FUNCTION = MantleLoot.registerFunction("set_fluid", (Serializer<? extends LootItemFunction>)SetFluidLootFunction.SERIALIZER);
        } else if (key == Registries.f_256976_) {
            BLOCK_TAG_CONDITION = (LootItemConditionType)Registry.m_122965_((Registry)BuiltInRegistries.f_256991_, (ResourceLocation)Mantle.getResource("block_tag"), (Object)new LootItemConditionType((Serializer)BlockTagLootCondition.SERIALIZER));
            TAG_EMPTY = (LootItemConditionType)Registry.m_122965_((Registry)BuiltInRegistries.f_256991_, (ResourceLocation)TagEmptyCondition.SERIALIZER.getID(), (Object)new LootItemConditionType(TagEmptyCondition.SERIALIZER));
            TAG_FILLED = (LootItemConditionType)Registry.m_122965_((Registry)BuiltInRegistries.f_256991_, (ResourceLocation)TagFilledCondition.SERIALIZER.getID(), (Object)new LootItemConditionType(TagFilledCondition.SERIALIZER));
        } else if (key == Registries.f_257032_) {
            TAG_PREFERENCE = (LootPoolEntryType)Registry.m_122965_((Registry)BuiltInRegistries.f_257035_, (ResourceLocation)Mantle.getResource("tag_preference"), (Object)new LootPoolEntryType((Serializer)new TagPreferenceLootEntry.Serializer()));
        }
    }

    private static LootItemFunctionType registerFunction(String name, Serializer<? extends LootItemFunction> serializer) {
        return (LootItemFunctionType)Registry.m_122965_((Registry)BuiltInRegistries.f_256753_, (ResourceLocation)Mantle.getResource(name), (Object)new LootItemFunctionType(serializer));
    }

    private MantleLoot() {
    }
}

