/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.java;

import it.unimi.dsi.fastutil.floats.Float2ObjectFunction;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.zeith.hammerlib.util.java.itf.FloatConsumer;
import org.zeith.hammerlib.util.java.itf.FloatPredicate;
import org.zeith.hammerlib.util.java.itf.FloatSupplier;

public final class OptionalFloat {
    private static final OptionalFloat EMPTY = new OptionalFloat();
    private final boolean isPresent;
    private final float value;

    private OptionalFloat() {
        this.isPresent = false;
        this.value = Float.NaN;
    }

    public static OptionalFloat empty() {
        return EMPTY;
    }

    private OptionalFloat(float value) {
        this.isPresent = true;
        this.value = value;
    }

    public static OptionalFloat of(float value) {
        return new OptionalFloat(value);
    }

    public float getAsFloat() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public boolean isEmpty() {
        return !this.isPresent;
    }

    public void ifPresent(FloatConsumer action) {
        if (this.isPresent) {
            action.accept(this.value);
        }
    }

    public void ifPresentOrElse(FloatConsumer action, Runnable emptyAction) {
        if (this.isPresent) {
            action.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public OptionalFloat filter(FloatPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (this.isEmpty()) {
            return this;
        }
        return predicate.test(this.value) ? this : OptionalFloat.empty();
    }

    public OptionalFloat map(FloatUnaryOperator map) {
        return this.isEmpty() ? this : OptionalFloat.of(map.apply(this.value));
    }

    public <T> Optional<T> mapToObj(Float2ObjectFunction<T> map) {
        return this.isEmpty() ? Optional.empty() : Optional.ofNullable(map.apply((Object)Float.valueOf(this.value)));
    }

    public float orElse(float other) {
        return this.isPresent ? this.value : other;
    }

    public float orElseGet(FloatSupplier supplier) {
        return this.isPresent ? this.value : supplier.getAsFloat();
    }

    public float orElseThrow() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public <X extends Throwable> float orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalFloat)) return false;
        OptionalFloat other = (OptionalFloat)obj;
        if (this.isPresent && other.isPresent) {
            if (Float.compare(this.value, other.value) != 0) return false;
            return true;
        } else if (this.isPresent != other.isPresent) return false;
        return true;
    }

    public int hashCode() {
        return this.isPresent ? Float.hashCode(this.value) : 0;
    }

    public String toString() {
        return this.isPresent ? "OptionalFloat[" + this.value + "]" : "OptionalFloat.empty";
    }

    public OptionalFloat or(OptionalFloat or) {
        return this.isPresent() ? this : or;
    }
}

