/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util;

import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AABBUtils {
    public static double EQUALITY_TOLERANCE = 1.0E-4;
    private static final Rotation[] ROTATIONS = Rotation.values();

    public static boolean notAlmostEqual(double a, double b) {
        return Math.abs(a - b) >= EQUALITY_TOLERANCE;
    }

    public static boolean almostEqual(double a, double b) {
        return Math.abs(a - b) < EQUALITY_TOLERANCE;
    }

    public static Vec3 randomPosWithin(AABB aabb, Random rng) {
        return new Vec3(Mth.m_14139_((double)rng.nextDouble(), (double)aabb.f_82288_, (double)aabb.f_82291_), Mth.m_14139_((double)rng.nextDouble(), (double)aabb.f_82289_, (double)aabb.f_82292_), Mth.m_14139_((double)rng.nextDouble(), (double)aabb.f_82290_, (double)aabb.f_82293_));
    }

    public static Vec3 randomPosWithin(AABB aabb, RandomSource rng) {
        return new Vec3(Mth.m_14139_((double)rng.m_188500_(), (double)aabb.f_82288_, (double)aabb.f_82291_), Mth.m_14139_((double)rng.m_188500_(), (double)aabb.f_82289_, (double)aabb.f_82292_), Mth.m_14139_((double)rng.m_188500_(), (double)aabb.f_82290_, (double)aabb.f_82293_));
    }

    public static AABB rotateNorthBox(AABB aabb, Direction rotationIn) {
        int d2d = rotationIn.m_122416_();
        if (d2d < 0) {
            throw new IllegalStateException("Unable to get Y-rotated facing of " + rotationIn);
        }
        return AABBUtils.rotate(aabb, ROTATIONS[(d2d + 2) % 4]);
    }

    public static AABB rotate(AABB aabb, Rotation rotationIn) {
        return switch (rotationIn) {
            case Rotation.CLOCKWISE_90 -> new AABB(1.0 - aabb.f_82293_, aabb.f_82289_, aabb.f_82288_, 1.0 - aabb.f_82290_, aabb.f_82292_, aabb.f_82291_);
            case Rotation.CLOCKWISE_180 -> new AABB(1.0 - aabb.f_82291_, aabb.f_82289_, 1.0 - aabb.f_82290_, 1.0 - aabb.f_82288_, aabb.f_82292_, 1.0 - aabb.f_82293_);
            case Rotation.COUNTERCLOCKWISE_90 -> new AABB(aabb.f_82290_, aabb.f_82289_, 1.0 - aabb.f_82288_, aabb.f_82293_, aabb.f_82292_, 1.0 - aabb.f_82291_);
            default -> aabb;
        };
    }

    public static AABB normalize(AABB aabb) {
        return aabb.m_82386_(-aabb.f_82288_, -aabb.f_82289_, -aabb.f_82290_);
    }

    public static AABB lerp(AABB prev, AABB cur, float pv) {
        return new AABB(Mth.m_14139_((double)pv, (double)prev.f_82288_, (double)cur.f_82288_), Mth.m_14139_((double)pv, (double)prev.f_82289_, (double)cur.f_82289_), Mth.m_14139_((double)pv, (double)prev.f_82290_, (double)cur.f_82290_), Mth.m_14139_((double)pv, (double)prev.f_82291_, (double)cur.f_82291_), Mth.m_14139_((double)pv, (double)prev.f_82292_, (double)cur.f_82292_), Mth.m_14139_((double)pv, (double)prev.f_82293_, (double)cur.f_82293_));
    }

    public static AABB extrudeGravity(AABB aabb, float ySpeed) {
        float ay = Math.abs(ySpeed);
        return aabb.m_82377_((double)(-ay) * (aabb.f_82291_ - aabb.f_82288_) / 2.0, (double)ay * (aabb.f_82292_ - aabb.f_82289_) / 2.0, (double)(-ay) * (aabb.f_82293_ - aabb.f_82290_) / 2.0).m_82386_(0.0, (double)(-ySpeed) * (aabb.f_82292_ - aabb.f_82289_) / 2.0, 0.0);
    }

    public static void cut(AABB box, AABB knife, List<AABB> intoList) {
        AABBUtils.cut(box, knife, intoList::add);
    }

    public static void cut(AABB box, AABB knife, Consumer<AABB> intoList) {
        if (!box.m_82381_(knife)) {
            intoList.accept(box);
            return;
        }
        AABB inter = box.m_82323_(knife);
        if (AABBUtils.notAlmostEqual(box.f_82289_, inter.f_82289_)) {
            intoList.accept(new AABB(box.f_82288_, box.f_82289_, box.f_82290_, box.f_82291_, inter.f_82289_, box.f_82293_));
        }
        if (AABBUtils.notAlmostEqual(box.f_82292_, inter.f_82292_)) {
            intoList.accept(new AABB(box.f_82288_, inter.f_82292_, box.f_82290_, box.f_82291_, box.f_82292_, box.f_82293_));
        }
        boolean eaX = AABBUtils.notAlmostEqual(box.f_82291_, inter.f_82291_);
        boolean eaZ = AABBUtils.notAlmostEqual(box.f_82293_, inter.f_82293_);
        if (eaX) {
            intoList.accept(new AABB(inter.f_82291_, inter.f_82289_, box.f_82290_, box.f_82291_, inter.f_82292_, inter.f_82293_));
        }
        if (eaZ) {
            intoList.accept(new AABB(box.f_82288_, inter.f_82289_, inter.f_82293_, inter.f_82291_, inter.f_82292_, box.f_82293_));
        }
        if (eaX && eaZ) {
            intoList.accept(new AABB(inter.f_82291_, inter.f_82289_, inter.f_82293_, box.f_82291_, inter.f_82292_, box.f_82293_));
        }
        boolean eaZ2 = AABBUtils.notAlmostEqual(box.f_82290_, inter.f_82290_);
        boolean eaX2 = AABBUtils.notAlmostEqual(box.f_82288_, inter.f_82288_);
        if (eaZ2) {
            intoList.accept(new AABB(inter.f_82288_, inter.f_82289_, box.f_82290_, inter.f_82291_, inter.f_82292_, inter.f_82290_));
        }
        if (eaX2) {
            intoList.accept(new AABB(box.f_82288_, inter.f_82289_, inter.f_82290_, inter.f_82288_, inter.f_82292_, inter.f_82293_));
        }
        if (eaZ2 || eaX2) {
            intoList.accept(new AABB(box.f_82288_, inter.f_82289_, box.f_82290_, inter.f_82288_, inter.f_82292_, inter.f_82290_));
        }
    }

    @Deprecated
    public static Vec3 getCenter(AABB aabb) {
        return aabb.m_82399_();
    }
}

