/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.js;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;

public class ExpressionFixer {
    private static final List<UnaryOperator<String>> FIXES = new ArrayList<UnaryOperator<String>>();

    public static void registerFix(UnaryOperator<String> fix) {
        FIXES.add(fix);
    }

    public static String fixExpression(String input) {
        for (UnaryOperator<String> fix : FIXES) {
            input = (String)fix.apply(input);
        }
        return input;
    }

    static {
        ExpressionFixer.registerFix(input -> input.replaceAll("[+\\-*\\/%&^|?]+\\s*\\)", ")"));
    }
}

