/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.objects;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.world.inventory.Slot;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.zeith.hammerlib.api.client.gui.IClientSlotPatch;
import org.zeith.hammerlib.client.flowgui.Graphics;
import org.zeith.hammerlib.client.flowgui.GuiObject;
import org.zeith.hammerlib.client.flowgui.MousePos;
import org.zeith.hammerlib.client.flowgui.util.ISlotLink;
import org.zeith.hammerlib.util.math.Point;

public class GuiSlotLinkObject
extends GuiObject
implements ISlotLink {
    protected Matrix4f transform;
    protected Matrix4f untransform;
    protected Slot slot;

    public GuiSlotLinkObject(String name) {
        super(name);
        this.size(16.0f, 16.0f);
    }

    public GuiSlotLinkObject bindToSlot(Slot slot) {
        this.slot = slot;
        IClientSlotPatch patch = (IClientSlotPatch)slot;
        patch.setLinkedHover(this);
        patch.setPos(Point.ZERO);
        return this;
    }

    @Override
    protected void render(Graphics gfx, MousePos pos) {
        this.transform = new Matrix4f((Matrix4fc)gfx.gfx().m_280168_().m_85850_().m_252922_());
        this.untransform = this.transform.invert(new Matrix4f());
    }

    @Override
    public boolean isValidFor(Slot slot) {
        return slot == this.slot;
    }

    @Override
    public void patchSlotTransforms(Slot slot, PoseStack pose) {
        if (!this.enabled || !this.visible || this.transform == null) {
            pose.m_85841_(Float.NaN, Float.NaN, Float.NaN);
            return;
        }
        pose.m_252931_(this.transform);
        pose.m_252880_(0.0f, 0.0f, -75.0f * this.width / 16.0f);
        pose.m_85841_(this.width / 16.0f, this.height / 16.0f, this.width / 16.0f);
    }

    @Override
    public boolean isMouseOver(Slot slot, double mouseX, double mouseY) {
        if (!this.enabled || !this.visible || this.transform == null) {
            return false;
        }
        Vector3f pos = this.untransform.transformPosition((float)mouseX, (float)mouseY, 0.0f, new Vector3f());
        return pos.x >= 0.0f && pos.y >= 0.0f && pos.x < this.width && pos.y < this.height;
    }
}

