/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.extradisks.data;

import de.melanx.extradisks.data.AdvancementProvider;
import de.melanx.extradisks.data.BlockStates;
import de.melanx.extradisks.data.ExtraLootTables;
import de.melanx.extradisks.data.ModItemModels;
import de.melanx.extradisks.data.ModTags;
import de.melanx.extradisks.data.Recipes;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="extradisks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataCreator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ModTags.BlockTags blockTagsProvider = new ModTags.BlockTags(output, lookupProvider, helper);
        boolean server = event.includeServer();
        generator.addProvider(server, (DataProvider)blockTagsProvider);
        generator.addProvider(server, (DataProvider)new ModTags.ItemTags(output, lookupProvider, blockTagsProvider.m_274426_(), helper));
        generator.addProvider(server, (DataProvider)new Recipes(output));
        generator.addProvider(server, (DataProvider)new AdvancementProvider(output, lookupProvider, helper));
        generator.addProvider(server, (DataProvider)new LootTableProvider(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(ExtraLootTables::new, LootContextParamSets.f_81421_))));
        boolean client = event.includeClient();
        generator.addProvider(client, (DataProvider)new ModItemModels(output, helper));
        generator.addProvider(client, (DataProvider)new BlockStates(output, helper));
    }
}

