/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.potion;

import dev.hexnowloading.dungeonnowloading.components.VertexNode;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.util.DNLMath;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;

public class VertexTransmissionEffect
extends MobEffect {
    private static final int DAMAGE_TICK_INTERVAL = 10;
    private static final float BASE_DAMAGE = 1.0f;
    private static final float DAMAGE_MULTIPLIER_PER_CONNECTION = 1.0f;
    private static final HashMap<UUID, VertexNode> entityVertexNodeMap = new HashMap();
    private static final HashMap<UUID, Integer> damageTickCountMap = new HashMap();
    private static final HashMap<UUID, Boolean> isReconnectionCaseMap = new HashMap();
    private static final HashMap<UUID, Boolean> isNoConnectionBeamDamageCaseMap = new HashMap();

    public VertexTransmissionEffect() {
        super(MobEffectCategory.HARMFUL, 0xE60000);
    }

    public VertexNode getVertexNode(UUID uuid) {
        return entityVertexNodeMap.get(uuid);
    }

    public void markAsReconnectionCase(UUID uuid) {
        isReconnectionCaseMap.put(uuid, true);
    }

    public void setNoConnectionBeamDamageCase(UUID uuid, boolean isCase) {
        isNoConnectionBeamDamageCaseMap.put(uuid, isCase);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        UUID uuid = entity.m_20148_();
        entityVertexNodeMap.computeIfAbsent(uuid, id -> new VertexNode((Entity)entity));
        damageTickCountMap.putIfAbsent(uuid, 5);
        isReconnectionCaseMap.putIfAbsent(uuid, false);
        isNoConnectionBeamDamageCaseMap.putIfAbsent(uuid, false);
        VertexNode vertexNode = entityVertexNodeMap.get(uuid);
        int damageTickCount = damageTickCountMap.get(uuid);
        boolean isNoConnectionBeamDamageCase = isNoConnectionBeamDamageCaseMap.get(uuid);
        if (damageTickCount == 0) {
            float damageAmount = 1.0f * (1.0f * (float)vertexNode.getConnectionCount());
            if (damageAmount > 0.0f || isNoConnectionBeamDamageCase) {
                if (isNoConnectionBeamDamageCase) {
                    damageAmount = 1.0f;
                    this.setNoConnectionBeamDamageCase(uuid, false);
                }
                entity.m_6469_(entity.m_9236_().m_269111_().m_269425_(), damageAmount);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), DNLSounds.VERTEX_ARROW_DAMAGE.get(), SoundSource.NEUTRAL, 1.0f, 1.2f / (DNLMath.randomRange(0.0f, 1.0f) * 0.2f + 0.9f));
            }
            damageTickCountMap.put(uuid, 10);
        } else {
            damageTickCountMap.put(uuid, damageTickCount - 1);
        }
        if (!(entity.m_21224_() || vertexNode.connectionLimitReached() || vertexNode.attemptedConnection())) {
            vertexNode.connectToNearbyNodes((Entity)entity, isReconnectionCaseMap.get(uuid));
        }
        vertexNode.tick((Entity)entity);
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        UUID uuid = entity.m_20148_();
        VertexNode vertexNode = entityVertexNodeMap.get(uuid);
        if (vertexNode != null) {
            vertexNode.disconnect_all();
        }
        entityVertexNodeMap.remove(uuid);
        damageTickCountMap.remove(uuid);
        isReconnectionCaseMap.remove(uuid);
        super.m_6386_(entity, attributeMap, amplifier);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration > 0;
    }
}

