/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.item;

import dev.hexnowloading.dungeonnowloading.config.GeneralConfig;
import dev.hexnowloading.dungeonnowloading.entity.misc.RepulsorEntity;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import dev.hexnowloading.dungeonnowloading.supporter.DNLSupporters;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RepulsorItem
extends Item {
    private static final String TAG_COSMETIC_MODE = "CosmeticMode";
    private static final String MODE_DEFAULT = "default";
    private static final String MODE_GOLDEN = "golden";

    public RepulsorItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Direction face = ctx.m_43719_();
        Level level = ctx.m_43725_();
        ItemStack stack = ctx.m_43722_();
        Player player = ctx.m_43723_();
        BlockPos clickedPos = ctx.m_8083_();
        if (level.m_8055_(clickedPos).m_60713_(Blocks.f_50074_)) {
            if (!level.f_46443_ && player != null) {
                boolean allowed;
                UUID uuid = player.m_20148_();
                boolean bl = allowed = DNLSupporters.hasSkin(uuid, "repulsor_golden") || DNLSupporters.isSupporter(uuid);
                if (allowed) {
                    RepulsorItem.cycleCosmeticMode(stack);
                    String mode = RepulsorItem.getCosmeticMode(stack);
                    String nice = Character.toUpperCase(mode.charAt(0)) + mode.substring(1);
                    player.m_5661_((Component)Component.m_237113_((String)("Current Repulsor: " + nice)).m_130940_(ChatFormatting.YELLOW), true);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (face == Direction.DOWN) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext placeCtx = new BlockPlaceContext(ctx);
        BlockPos placePos = placeCtx.m_8083_();
        Vec3 center = Vec3.m_82539_((Vec3i)placePos);
        AABB aabb = DNLEntityTypes.REPULSOR.get().m_20680_().m_20384_(center.m_7096_(), center.m_7098_(), center.m_7094_());
        if (!level.m_45756_((Entity)null, aabb) || !level.m_45933_((Entity)null, aabb).isEmpty()) {
            return InteractionResult.FAIL;
        }
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            Consumer consumer = EntityType.m_263562_((ServerLevel)server, (ItemStack)stack, (Player)ctx.m_43723_());
            RepulsorEntity rep = (RepulsorEntity)DNLEntityTypes.REPULSOR.get().m_262451_(server, stack.m_41783_(), consumer, placePos, MobSpawnType.SPAWN_EGG, true, true);
            if (rep == null) {
                return InteractionResult.FAIL;
            }
            rep.m_7678_(rep.m_20185_(), rep.m_20186_(), rep.m_20189_(), 0.0f, 0.0f);
            rep.m_146922_(0.0f);
            rep.m_5616_(0.0f);
            rep.setShieldHealth(this.m_41462_() - stack.m_41773_());
            rep.setSourceStack(stack);
            boolean canGolden = player != null && (DNLSupporters.hasSkin(player.m_20148_(), "repulsor_golden") || DNLSupporters.isSupporter(player.m_20148_()));
            rep.setSkin(canGolden && RepulsorItem.isGoldenMode(stack) ? RepulsorEntity.Skin.GOLDEN : RepulsorEntity.Skin.DEFAULT);
            rep.setSkinValidation(true);
            server.m_47205_((Entity)rep);
            level.m_6263_(null, rep.m_20185_(), rep.m_20186_(), rep.m_20189_(), SoundEvents.f_11684_, SoundSource.BLOCKS, 0.75f, 0.8f);
            rep.m_146852_(GameEvent.f_157810_, (Entity)player);
        }
        stack.m_41774_(1);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private static void cycleCosmeticMode(ItemStack stack) {
        String current = RepulsorItem.getCosmeticMode(stack);
        String next = current.equals(MODE_DEFAULT) ? MODE_GOLDEN : MODE_DEFAULT;
        stack.m_41784_().m_128359_(TAG_COSMETIC_MODE, next);
    }

    public static String getCosmeticMode(ItemStack stack) {
        String v = stack.m_41784_().m_128461_(TAG_COSMETIC_MODE);
        return v.isEmpty() ? MODE_DEFAULT : v;
    }

    public static boolean isGoldenMode(ItemStack stack) {
        return MODE_GOLDEN.equals(RepulsorItem.getCosmeticMode(stack));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        super.m_7373_(stack, level, components, flag);
        if (((Boolean)GeneralConfig.TOGGLE_HELPFUL_ITEM_TOOLTIP.get()).booleanValue()) {
            components.add((Component)Component.m_237115_((String)"item.dungeonnowloading.repulsor.tooltip.ability_name").m_130940_(ChatFormatting.GRAY));
            components.add((Component)Component.m_237115_((String)"item.dungeonnowloading.repulsor.tooltip.ability_description").m_130940_(ChatFormatting.DARK_GRAY));
            components.add(CommonComponents.f_237098_);
            components.add((Component)Component.m_237115_((String)"item.dungeonnowloading.repulsor.tooltip.right_click").m_130940_(ChatFormatting.GRAY));
            components.add((Component)Component.m_237115_((String)"item.dungeonnowloading.repulsor.tooltip.right_click.description").m_130940_(ChatFormatting.DARK_GREEN));
            components.add(CommonComponents.f_237098_);
            components.add((Component)Component.m_237115_((String)"item.dungeonnowloading.repulsor.tooltip.right_click_with_redstone_dust").m_130940_(ChatFormatting.GRAY));
            components.add((Component)Component.m_237115_((String)"item.dungeonnowloading.repulsor.tooltip.right_click_with_redstone_dust.description").m_130940_(ChatFormatting.DARK_GREEN));
        }
    }

    public static void setCosmeticMode(ItemStack stack, String mode) {
        stack.m_41784_().m_128359_(TAG_COSMETIC_MODE, mode);
    }

    public static void setGolden(ItemStack stack) {
        RepulsorItem.setCosmeticMode(stack, MODE_GOLDEN);
    }

    public static void setDefault(ItemStack stack) {
        RepulsorItem.setCosmeticMode(stack, MODE_DEFAULT);
    }

    public boolean m_6832_(ItemStack stack, ItemStack repairItem) {
        return repairItem.m_150930_(Items.f_42451_) || super.m_6832_(stack, repairItem);
    }
}

