/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.util;

import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Consumer;

public class AnimationChainer<T extends Enum<T>> {
    private final Queue<AnimationStep<T>> animationQueue = new LinkedList<AnimationStep<T>>();
    private AnimationStep<T> currentStep = null;
    private int ticksRemaining = 0;
    private boolean started = false;

    public void enqueue(AnimationStep<T> step) {
        this.animationQueue.add(step);
    }

    public void tick(Consumer<T> transitionFunction) {
        if (this.currentStep == null && !this.animationQueue.isEmpty()) {
            this.currentStep = this.animationQueue.poll();
            this.ticksRemaining = this.currentStep.durationTicks;
            transitionFunction.accept((Enum)this.currentStep.animation);
            if (this.currentStep.onStart != null) {
                this.currentStep.onStart.run();
            }
            this.started = true;
        } else if (this.currentStep != null && !this.currentStep.isHanging && --this.ticksRemaining <= 0) {
            if (this.currentStep.onComplete != null) {
                this.currentStep.onComplete.run();
            }
            if (this.currentStep.isLooping) {
                this.ticksRemaining = this.currentStep.durationTicks;
                transitionFunction.accept((Enum)this.currentStep.animation);
                if (this.currentStep.onStart != null) {
                    this.currentStep.onStart.run();
                }
            } else {
                this.currentStep = null;
            }
        }
    }

    public void forceNext(Consumer<T> transitionFunction) {
        if (this.currentStep != null && this.currentStep.isLooping) {
            if (this.currentStep.onComplete != null) {
                this.currentStep.onComplete.run();
            }
            this.currentStep = null;
            this.tick(transitionFunction);
        }
    }

    public void reset() {
        this.animationQueue.clear();
        this.currentStep = null;
        this.ticksRemaining = 0;
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isFinished() {
        return this.started && this.currentStep == null && this.animationQueue.isEmpty();
    }

    public boolean isLooping() {
        return this.currentStep != null && this.currentStep.isLooping;
    }

    public boolean isHanging() {
        return this.currentStep != null && this.currentStep.isHanging;
    }

    public boolean isEmpty() {
        return this.animationQueue.isEmpty();
    }

    public static class AnimationStep<T> {
        final T animation;
        final int durationTicks;
        final boolean isLooping;
        final boolean isHanging;
        final Runnable onStart;
        final Runnable onComplete;

        private AnimationStep(T animation, float seconds, boolean looping, boolean hanging, Runnable onStart, Runnable onComplete) {
            this.animation = animation;
            this.durationTicks = (int)(seconds * 20.0f);
            this.isLooping = looping;
            this.isHanging = hanging;
            this.onStart = onStart;
            this.onComplete = onComplete;
        }

        public static <T> AnimationStep<T> of(T animation, float seconds) {
            return new AnimationStep<T>(animation, seconds, false, false, null, null);
        }

        public static <T> AnimationStep<T> of(T animation, float seconds, Runnable onStart, Runnable onEnd) {
            return new AnimationStep<T>(animation, seconds, false, false, onStart, onEnd);
        }

        public static <T> AnimationStep<T> looping(T animation, float seconds) {
            return new AnimationStep<T>(animation, seconds, true, false, null, null);
        }

        public static <T> AnimationStep<T> looping(T animation, float seconds, Runnable onStart, Runnable onEnd) {
            return new AnimationStep<T>(animation, seconds, true, false, onStart, onEnd);
        }

        public static <T> AnimationStep<T> hanging(T animation) {
            return new AnimationStep<T>(animation, 0.0f, false, true, null, null);
        }

        public static <T> AnimationStep<T> hanging(T animation, Runnable onStart) {
            return new AnimationStep<T>(animation, 0.0f, false, true, onStart, null);
        }
    }
}

