/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.projectile;

import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentEntity;
import dev.hexnowloading.dungeonnowloading.entity.util.ModelledProjectileEntity;
import dev.hexnowloading.dungeonnowloading.particle.type.AxisParticleType;
import dev.hexnowloading.dungeonnowloading.particle.type.ScalableParticleType;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLParticleTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLTags;
import dev.hexnowloading.dungeonnowloading.util.DNLLevelUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class VertexOrbProjectileEntity
extends ModelledProjectileEntity {
    private static final EntityDataAccessor<Integer> HURT_TIME = SynchedEntityData.m_135353_(VertexOrbProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HURT_TIME_DIRECT = SynchedEntityData.m_135353_(VertexOrbProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(VertexOrbProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Vector3f> VELOCITY = SynchedEntityData.m_135353_(VertexOrbProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private static final EntityDataAccessor<Integer> RADIUS = SynchedEntityData.m_135353_(VertexOrbProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DYING_TICK = SynchedEntityData.m_135353_(VertexOrbProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> GROUND_COLLISION = SynchedEntityData.m_135353_(VertexOrbProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int BASE_DAMAGE = 6;
    private static final int SLOWNESS_DURATION = 20;
    private static final int SLOWNESS_AMPLIFIER = 4;
    private static final float HEALTH = 5.0f;
    private static final double BEAM_INITIAL_PARTICLE_SPACING = 0.5;
    private static final float BEAM_INITIAL_PARTICLE_SCALE_MIN = 0.2f;
    private static final float BEAM_INITIAL_PARTICLE_SCALE_MAX = 0.4f;
    private static final double BEAM_PARTICLE_SPACING = 0.1;
    private static final float BEAM_PARTICLE_SCALE = 0.05f;
    private static final float MAX_RANDOM_PARTICLE_SCALE_MULTIPLIER = 3.0f;
    public static final int DURATION_ON_GROUND = 300;
    private double xPower;
    private double yPower;
    private double zPower;
    private int life;
    private int expansionTick;
    private boolean hasAppliedMovement;
    private boolean hasLanded;
    private boolean delayTick;
    private boolean explosionImmune;

    public VertexOrbProjectileEntity(EntityType<? extends VertexOrbProjectileEntity> entityType, Level level) {
        super(entityType, level);
    }

    public VertexOrbProjectileEntity(Level level, LivingEntity owner, int radius) {
        this((EntityType<? extends VertexOrbProjectileEntity>)DNLEntityTypes.VERTEX_ORB_PROJECTILE.get(), level);
        this.setOwner((Entity)owner);
        this.setRadius(radius);
        this.setDyingTick(0);
        this.life = 0;
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        ListTag listTag;
        super.m_7378_(compoundTag);
        if (compoundTag.m_128425_("power", 9) && (listTag = compoundTag.m_128437_("power", 6)).size() == 3) {
            this.xPower = listTag.m_128772_(0);
            this.yPower = listTag.m_128772_(1);
            this.zPower = listTag.m_128772_(2);
        }
        if (compoundTag.m_128425_("life", 3)) {
            this.life = compoundTag.m_128451_("life");
        }
        if (compoundTag.m_128425_("radius", 3)) {
            this.setRadius(compoundTag.m_128451_("radius"));
        }
        this.hasLanded = compoundTag.m_128471_("hasLanded");
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128365_("power", (Tag)this.m_20063_(new double[]{this.xPower, this.yPower, this.zPower}));
        compoundTag.m_128405_("life", this.life);
        compoundTag.m_128405_("radius", this.getRadius());
        compoundTag.m_128379_("hasLanded", this.hasLanded);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(HURT_TIME, (Object)0);
        this.f_19804_.m_135372_(HURT_TIME_DIRECT, (Object)1);
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(VELOCITY, (Object)Vec3.f_82478_.m_252839_());
        this.f_19804_.m_135372_(RADIUS, (Object)0);
        this.f_19804_.m_135372_(DYING_TICK, (Object)0);
        this.f_19804_.m_135372_(GROUND_COLLISION, (Object)false);
    }

    @Override
    protected void tickProjectile() {
        if (this.getDyingTick() > 0) {
            this.setDyingTick(this.getDyingTick() - 1);
            if (this.getDyingTick() <= 0) {
                this.m_146870_();
            }
            return;
        }
        if (!this.hasAppliedMovement) {
            if (!this.m_9236_().f_46443_) {
                this.m_20334_(this.xPower, this.yPower, this.zPower);
                this.setVelocity(new Vec3(this.xPower, this.yPower, this.zPower));
            } else {
                double d = this.getVelocity().x * this.getVelocity().x + this.getVelocity().y * this.getVelocity().y + this.getVelocity().z * this.getVelocity().z;
                if (!this.delayTick && d < 1.0E-7) {
                    this.delayTick = true;
                    return;
                }
                this.m_20256_(new Vec3((double)this.getVelocity().x, (double)this.getVelocity().y, (double)this.getVelocity().z));
            }
            this.hasAppliedMovement = true;
        }
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        this.m_20101_();
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.life <= 0) {
            this.m_9236_().m_7106_((ParticleOptions)DustParticleOptions.f_123656_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (this.m_20096_() || this.f_19862_ || this.m_20184_().m_82556_() < 1.0E-7 && this.life <= 0) {
            this.life = 300;
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, this.m_5720_(), 3.0f, 1.0f);
            this.spawnInitialRedstoneParticles();
            this.expansionTick = 40;
            if (!this.m_9236_().f_46443_) {
                this.f_19804_.m_135381_(GROUND_COLLISION, (Object)this.m_20096_());
            }
            this.blockDestruction();
        }
        if (this.life > 0) {
            --this.life;
            if (this.expansionTick > 0) {
                --this.expansionTick;
            }
            this.applyEffect();
            if (this.life > 50) {
                this.spawnRedstoneParticle();
            }
            if (!(this.m_9236_().f_46443_ || this.life > 0 && ((Boolean)this.f_19804_.m_135370_(GROUND_COLLISION)).booleanValue() && !this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60795_())) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public void m_20256_(Vec3 vec31) {
        Vec3 vec3 = vec31;
        if (((Boolean)this.f_19804_.m_135370_(GROUND_COLLISION)).booleanValue()) {
            vec3 = Vec3.f_82478_;
        }
        super.m_20256_(vec3);
    }

    private void blockDestruction() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.2f) * 0.7f);
        BlockPos pos = this.m_20183_();
        int r = this.getRadius();
        for (int x = -r; x <= r; ++x) {
            for (int z = -r; z <= r; ++z) {
                for (int y = -r; y <= r; ++y) {
                    BlockPos targetPos = new BlockPos(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z);
                    BlockState blockState = this.m_9236_().m_8055_(targetPos);
                    if (blockState.m_60795_() || blockState.m_204336_(BlockTags.f_13070_) || blockState.m_204336_(DNLTags.TORCH_BLOCKS)) continue;
                    DNLLevelUtil.destroyBlockMulti(this.m_9236_(), targetPos, false, this, 3);
                }
            }
        }
    }

    private void applyEffect() {
        Level level = this.m_9236_();
        if (level.f_46443_) {
            return;
        }
        int r = this.getRadius();
        AABB effectBox = new AABB(this.m_20185_() - (double)r, this.m_20186_() - (double)r, this.m_20189_() - (double)r, this.m_20185_() + (double)r, this.m_20186_() + (double)r, this.m_20189_() + (double)r);
        List entities = this.m_9236_().m_45976_(LivingEntity.class, effectBox);
        for (LivingEntity entity : entities) {
            if (entity instanceof FairkeeperSerpentEntity || !this.applyDamage((Entity)entity, 6, 0.6f)) continue;
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 4));
            this.spawnRedstoneBeamParticle((ServerLevel)level, entity);
        }
    }

    private void spawnRedstoneBeamParticle(ServerLevel level, LivingEntity target) {
        Vec3 start = this.m_20182_().m_82520_(0.0, this.m_20191_().m_82376_() / 2.0, 0.0);
        Vec3 end = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.5, 0.0);
        Vec3 direction = end.m_82546_(start);
        double distance = direction.m_82553_();
        double stepSize = 0.5;
        int particleCount = (int)(distance / stepSize);
        Vec3 step = direction.m_82541_().m_82490_(stepSize);
        float particleScale = 0.2f + (float)Math.random() * 0.2f;
        ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), particleScale);
        for (int i = 0; i <= particleCount; ++i) {
            Vec3 particlePos = start.m_82549_(step.m_82490_((double)i));
            level.m_8767_((ParticleOptions)particleData, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void spawnInitialRedstoneParticles() {
        float particleScale = 0.2f + (float)Math.random() * 0.2f;
        ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), particleScale);
        for (int i = 0; i < 10; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)particleData, this.m_20185_() + (double)(2.0f * (this.m_9236_().m_213780_().m_188501_() - this.m_9236_().m_213780_().m_188501_())), this.m_20186_() + (double)(2.0f * (this.m_9236_().m_213780_().m_188501_() - this.m_9236_().m_213780_().m_188501_())), this.m_20189_() + (double)(2.0f * (this.m_9236_().m_213780_().m_188501_() - this.m_9236_().m_213780_().m_188501_())), 0.0, 0.0, 0.0);
        }
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
    }

    private void spawnRedstoneParticle() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.m_9236_().m_213780_().m_188501_() > 0.3f) {
            return;
        }
        int radius = this.getRadius();
        Vec3 center = this.m_20182_();
        double centerX = center.f_82479_;
        double centerY = center.f_82480_ - 0.5;
        double centerZ = center.f_82481_;
        int side = this.m_9236_().m_213780_().m_188503_(4);
        double x = centerX;
        double z = centerZ;
        float angleToSide = 0.0f;
        switch (side) {
            case 0: {
                x = centerX + (double)radius + 0.49;
                z = centerZ - (double)radius + this.m_9236_().m_213780_().m_188500_() * (double)(radius * 2);
                angleToSide = 270.0f;
                break;
            }
            case 1: {
                x = centerX - (double)radius - 0.49;
                z = centerZ - (double)radius + this.m_9236_().m_213780_().m_188500_() * (double)(radius * 2);
                angleToSide = 90.0f;
                break;
            }
            case 2: {
                z = centerZ + (double)radius + 0.49;
                x = centerX - (double)radius + this.m_9236_().m_213780_().m_188500_() * (double)(radius * 2);
                angleToSide = 180.0f;
                break;
            }
            case 3: {
                z = centerZ - (double)radius - 0.49;
                x = centerX - (double)radius + this.m_9236_().m_213780_().m_188500_() * (double)(radius * 2);
                angleToSide = 360.0f;
            }
        }
        angleToSide = (angleToSide + 360.0f) % 360.0f;
        serverLevel.m_8767_((ParticleOptions)new AxisParticleType.AxisParticleData(DNLParticleTypes.VERTEX_BOUNDARY_PARTICLE.get(), 1, angleToSide), x, centerY, z, 1, 0.0, 0.02, 0.0, 0.0);
    }

    private void spawnParticleOnAllPlanes(ParticleOptions particleData, Vec3 center, int radius) {
        double centerX = center.f_82479_;
        double centerY = center.f_82480_;
        double centerZ = center.f_82481_;
    }

    @Override
    protected void onHitEntity(EntityHitResult entityHitResult) {
        this.applyDamage(entityHitResult.m_82443_(), 6, 0.6f);
    }

    private boolean applyDamage(Entity targetEntity, int baseDamage, float ownerAttackPercentage) {
        Entity entity;
        LivingEntity owner = null;
        int damage = baseDamage;
        if (this.m_19749_() != null && (entity = this.m_19749_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            damage = (int)(livingEntity.m_21133_(Attributes.f_22281_) * (double)ownerAttackPercentage);
            owner = livingEntity;
        }
        if (targetEntity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)targetEntity;
            return target.m_6469_(this.m_9236_().m_269111_().m_269299_((Entity)this, owner), (float)damage);
        }
        return false;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_7337_(Entity entity) {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_7334_(Entity $$0) {
    }

    public void m_5997_(double $$0, double $$1, double $$2) {
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268565_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        boolean bl;
        if (this.m_6673_(damageSource)) {
            return false;
        }
        if (this.getDyingTick() > 0) {
            return false;
        }
        if (this.m_9236_().f_46443_ || this.m_213877_()) {
            return true;
        }
        if (this.explosionImmune) {
            return false;
        }
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() + f);
        this.m_5834_();
        this.m_146852_(GameEvent.f_223706_, damageSource.m_7639_());
        boolean bl2 = bl = damageSource.m_7639_() instanceof Player && ((Player)damageSource.m_7639_()).m_150110_().f_35937_;
        if (bl || this.getDamage() > 5.0f) {
            if (this.getLife() > 0) {
                this.setDyingTick(20);
                this.m_6210_();
            } else {
                this.m_146870_();
            }
            ScalableParticleType.ScalableParticleData particleData = new ScalableParticleType.ScalableParticleData(DNLParticleTypes.REDSTONE_SHOCKWAVE_PARTICLE.get(), 1.0f);
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, this.m_5720_(), 1.0f, 2.0f);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)particleData, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        return true;
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.getDyingTick() > 0) {
            return EntityDimensions.m_20398_((float)0.0f, (float)0.0f);
        }
        return EntityDimensions.m_20395_((float)1.0f, (float)1.0f);
    }

    public void m_6053_(float f) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    public void shootTowardsTarget(double x, double y, double z, LivingEntity target, float speed, float inaccuracy) {
        this.shoot(x, y, z, target.m_20185_(), target.m_20186_(), target.m_20189_(), speed, inaccuracy);
    }

    public void shoot(double x, double y, double z, double targetX, double targetY, double targetZ, float speed, float inaccuracy) {
        this.m_7678_(x, y, z, this.m_146908_(), this.m_146909_());
        this.m_20090_();
        Vec3 direction = new Vec3(targetX - this.m_20185_(), targetY - this.m_20186_(), targetZ - this.m_20189_()).m_82541_();
        double randX = Mth.m_216263_((RandomSource)this.f_19796_, (double)-1.0, (double)1.0) * (double)inaccuracy;
        double randY = Mth.m_216263_((RandomSource)this.f_19796_, (double)-1.0, (double)1.0) * (double)inaccuracy;
        double randZ = Mth.m_216263_((RandomSource)this.f_19796_, (double)-1.0, (double)1.0) * (double)inaccuracy;
        Vec3 inaccurateDirection = new Vec3(direction.f_82479_ + randX, direction.f_82480_ + randY, direction.f_82481_ + randZ).m_82541_();
        this.xPower = inaccurateDirection.f_82479_ * (double)speed;
        this.yPower = inaccurateDirection.f_82480_ * (double)speed;
        this.zPower = inaccurateDirection.f_82481_ * (double)speed;
        this.m_20334_(this.xPower, this.yPower, this.zPower);
        this.setVelocity(new Vec3(this.xPower, this.yPower, this.zPower));
        this.hasAppliedMovement = true;
    }

    public int getLife() {
        return this.life;
    }

    public int getMaxLife() {
        return 300;
    }

    public void setDamage(float f) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(f));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setHurtTime(int i) {
        this.f_19804_.m_135381_(HURT_TIME, (Object)i);
    }

    public int getHurtTime() {
        return (Integer)this.f_19804_.m_135370_(HURT_TIME);
    }

    public void setHurtDir(int i) {
        this.f_19804_.m_135381_(HURT_TIME_DIRECT, (Object)i);
    }

    public int getHurtDir() {
        return (Integer)this.f_19804_.m_135370_(HURT_TIME_DIRECT);
    }

    public void setVelocity(Vec3 vec3) {
        this.f_19804_.m_135381_(VELOCITY, (Object)vec3.m_252839_());
    }

    public Vector3f getVelocity() {
        return (Vector3f)this.f_19804_.m_135370_(VELOCITY);
    }

    public void setRadius(int radius) {
        this.f_19804_.m_135381_(RADIUS, (Object)radius);
    }

    public int getRadius() {
        return (Integer)this.f_19804_.m_135370_(RADIUS);
    }

    public void setDyingTick(int tick) {
        this.f_19804_.m_135381_(DYING_TICK, (Object)tick);
    }

    public int getDyingTick() {
        return (Integer)this.f_19804_.m_135370_(DYING_TICK);
    }

    public int getExpansionTick() {
        return this.expansionTick;
    }
}

