/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai;

import dev.hexnowloading.dungeonnowloading.entity.ai.StoppableGoal;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperBorosEntity;
import dev.hexnowloading.dungeonnowloading.entity.boss.FairkeeperSerpentCallerEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class FairkeeperBorosTackleGoal
extends StoppableGoal {
    private final FairkeeperBorosEntity boros;
    private final FairkeeperBorosEntity.FairkeeperBorosState state;
    private final double speed;
    private LivingEntity target;
    private Vec3 targetPosition;
    private final double tackleRange;
    private final double addSpeedBy;
    private int tackleDuration;
    private int tackleCooldown;
    private int arenaSize;
    private int loopCount;
    private int totalDuration;
    private int crashDuration;
    private BlockPos arenaCenter;
    private final int TACKLE_DURATION = FairkeeperBorosTackleGoal.m_186073_((int)40);
    private final int SLOWDOWN_DURATION = FairkeeperBorosTackleGoal.m_186073_((int)10);
    private final int TACKLE_COOLDOWN = FairkeeperBorosTackleGoal.m_186073_((int)40);
    private final int EXPIRY_DURATION = FairkeeperBorosTackleGoal.m_186073_((int)300);
    private final int CRASH_DURATION = FairkeeperBorosTackleGoal.m_186073_((int)40);
    private final int TOTAL_LOOP = 3;
    private final double SLOWDOWN_SPEED_BY = 0.5;
    private static final float OFFSET_FROM_WALL = 1.5f;

    public FairkeeperBorosTackleGoal(FairkeeperBorosEntity.FairkeeperBorosState state, FairkeeperBorosEntity boros, double speed, double tackleRange, double addSpeedBy) {
        this.state = state;
        this.boros = boros;
        this.speed = speed;
        this.tackleRange = tackleRange;
        this.addSpeedBy = addSpeedBy;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        this.target = this.boros.m_5448_();
        return this.target != null && this.target.m_6084_() && this.boros.isState(this.state);
    }

    @Override
    public void m_8056_() {
        this.targetPosition = this.target.m_20318_(1.0f);
        FairkeeperSerpentCallerEntity caller = this.boros.getCaller();
        this.arenaSize = caller != null ? caller.getArenaSize() : 0;
        this.arenaCenter = caller != null ? caller.m_20183_() : BlockPos.f_121853_;
        this.loopCount = 0;
        this.tackleCooldown = 0;
        this.totalDuration = this.EXPIRY_DURATION;
        super.m_8056_();
    }

    public void m_8041_() {
        this.boros.stopAttacking(20);
        this.boros.transitionTo(FairkeeperBorosEntity.FairkeeperBorosAnimationState.MOUTH_CLOSE);
    }

    public void m_8037_() {
        double updatedSpeed = this.speed;
        double distanceSqr = this.boros.m_20280_((Entity)this.target);
        this.targetPosition = this.target.m_20318_(1.0f);
        if (this.totalDuration > 0) {
            --this.totalDuration;
        } else if (this.tackleDuration <= 0) {
            this.stopGoal();
            return;
        }
        if (this.tackleCooldown > 0) {
            --this.tackleCooldown;
        }
        if (this.tackleCooldown <= 0 && this.tackleDuration <= 0 && distanceSqr < this.tackleRange * this.tackleRange) {
            this.tackleDuration = this.TACKLE_DURATION + this.SLOWDOWN_DURATION;
            this.boros.playMouthOpenAndClose();
        }
        if (this.tackleDuration > 0) {
            boolean isInsideArena;
            --this.tackleDuration;
            updatedSpeed = this.tackleDuration > this.TACKLE_DURATION ? this.speed - 0.5 : this.speed + this.addSpeedBy;
            double viewDistance = 1.5;
            Vec3 offset = this.boros.m_20252_(1.0f).m_82490_(viewDistance);
            Vec3 potentialTargetPosition = this.boros.m_20182_().m_82549_(offset);
            double minX = (float)this.arenaCenter.m_123341_() + 0.5f - (float)this.arenaSize + 1.5f;
            double maxX = (float)this.arenaCenter.m_123341_() + 0.5f + (float)this.arenaSize - 1.5f;
            double minZ = (float)this.arenaCenter.m_123343_() + 0.5f - (float)this.arenaSize + 1.5f;
            double maxZ = (float)this.arenaCenter.m_123343_() + 0.5f + (float)this.arenaSize - 1.5f;
            boolean bl = isInsideArena = potentialTargetPosition.f_82479_ >= minX && potentialTargetPosition.f_82479_ <= maxX && potentialTargetPosition.f_82481_ >= minZ && potentialTargetPosition.f_82481_ <= maxZ;
            if (isInsideArena) {
                this.targetPosition = potentialTargetPosition;
            } else {
                this.crashDuration = this.CRASH_DURATION;
                this.tackleDuration = 0;
            }
            if (this.tackleDuration <= 0) {
                if (this.loopCount == 3) {
                    this.stopGoal();
                    return;
                }
                ++this.loopCount;
                this.tackleCooldown = this.TACKLE_COOLDOWN;
            }
        }
        if (this.crashDuration > 0) {
            --this.crashDuration;
            updatedSpeed = this.speed - 0.5;
        }
        this.boros.m_21566_().m_6849_(this.targetPosition.f_82479_, this.targetPosition.f_82480_, this.targetPosition.f_82481_, updatedSpeed);
    }
}

